/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.json;

import clover.edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import clover.org.apache.velocity.VelocityContext;
import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.CloverException;
import com.cenqua.clover.CloverStartup;
import com.cenqua.clover.Logger;
import com.cenqua.clover.cfg.Interval;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.reporters.CloverReportConfig;
import com.cenqua.clover.reporters.Current;
import com.cenqua.clover.reporters.Format;
import com.cenqua.clover.reporters.html.HtmlRenderingSupport;
import com.cenqua.clover.reporters.html.HtmlReportUtil;
import com.cenqua.clover.reporters.json.RenderJSONAction;
import com.cenqua.clover.util.CloverExecutor;
import com.cenqua.clover.util.CloverExecutors;
import com.cenqua.clover.util.CloverUtils;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class JSONReporter {
    private Current mCurrent;
    private HtmlRenderingSupport mHelper;
    private File mBasePath;
    private CloverDatabase mDb;
    static /* synthetic */ Class class$com$cenqua$clover$reporters$html$HtmlReporter;

    public JSONReporter(CloverReportConfig cfg) throws IOException, CloverException {
        this.mCurrent = (Current)cfg;
        this.mDb = this.mCurrent.getCoverageDatabase();
        this.mHelper = new HtmlRenderingSupport(cfg.getFormat(), true);
        this.mBasePath = this.mCurrent.getOutFile();
        CloverUtils.createDir(this.mBasePath);
    }

    public static void generateReport(CloverReportConfig cfg) throws CloverException {
        try {
            new JSONReporter(cfg).createReport();
        }
        catch (Exception e) {
            throw new CloverException("Error generating JSON report: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createReport() throws Exception {
        long currentStartTime = System.currentTimeMillis();
        ProjectInfo projectInfo = this.mDb.getFullModel();
        projectInfo.buildCaches();
        List pkgs = projectInfo.getPackages();
        try {
            CloverExecutor service = CloverExecutors.newCloverExecutor(this.mCurrent.getNumThreads(), "Clover-JSON");
            Logger.getInstance().info("Generating JSON report to: " + this.mCurrent.getOutFile().getAbsolutePath());
            RenderJSONAction.initThreadLocals();
            Iterator it = pkgs.iterator();
            while (it.hasNext()) {
                PackageInfo pkg = (PackageInfo)it.next();
                Logger.getInstance().verbose("Processing package " + pkg.getName());
                long start = System.currentTimeMillis();
                this.processPackage(pkg, service);
                long total = System.currentTimeMillis() - start;
                if (!Logger.isDebug()) continue;
                Logger.getInstance().debug("Processed package: " + pkg.getName() + " (" + pkg.getClasses().size() + " classes, " + pkg.getMetrics().getNumTests() + " tests)" + " in " + total + "ms");
            }
            service.shutdown();
            Interval timeOut = this.mCurrent.getTimeOut();
            if (!service.awaitTermination(timeOut.getValueInMillis(), TimeUnit.MILLISECONDS)) {
                throw new CloverException("Timout of '" + timeOut + "' reached during report generation. " + "Please increase this value and try again.");
            }
        }
        finally {
            RenderJSONAction.resetThreadLocals();
        }
        long currentTotalTime = System.currentTimeMillis() - currentStartTime;
        int pkgCount = pkgs.size();
        long msPerPkg = pkgCount == 0 ? currentTotalTime : currentTotalTime / (long)pkgCount;
        Logger.getInstance().info("Done. Processed " + pkgCount + " packages in " + currentTotalTime + "ms (" + msPerPkg + "ms per package).");
    }

    private void processPackage(PackageInfo pkg, CloverExecutor service) throws Exception {
        List files = pkg.getFiles();
        ProjectInfo projectInfo = this.mDb.getFullModel();
        projectInfo.buildCaches();
        Iterator it = files.iterator();
        while (it.hasNext()) {
            FileInfo file = (FileInfo)it.next();
            VelocityContext context = new VelocityContext();
            service.submit(new RenderJSONAction(file, this.mHelper, this.mCurrent, context, this.mDb, projectInfo));
        }
    }

    private static void usage(String msg) {
        System.err.println();
        if (msg != null) {
            System.err.println("  *** ERROR: " + msg);
        }
        System.err.println();
        System.err.println("  USAGE: " + (class$com$cenqua$clover$reporters$html$HtmlReporter == null ? (class$com$cenqua$clover$reporters$html$HtmlReporter = JSONReporter.class$("com.cenqua.clover.reporters.html.HtmlReporter")) : class$com$cenqua$clover$reporters$html$HtmlReporter).getName() + " [OPTIONS] PARAMS\n\n" + "  PARAMS:\n" + "    -i, --initstring <string>\tclover initstring\n\n" + "    -o, --outputdir <dir>\toutput directory for generated html.\n\n" + "  OPTIONS:\n" + "    -d, --debug \t\tswitch logging level to debug\n\n" + "    -v, --verbose \t\tswitch logging level to verbose\n\n");
    }

    public static void main(String[] args) {
        System.exit(JSONReporter.mainImpl(args));
    }

    public static int mainImpl(String[] args) {
        CloverStartup.loadLicense(Logger.getInstance());
        Current cfg = JSONReporter.processArgs(args);
        if (cfg == null || HtmlReportUtil.getVelocityEngine() == null) {
            return 1;
        }
        try {
            new JSONReporter(cfg).createReport();
            return 0;
        }
        catch (IOException ioe) {
            Logger.getInstance().error("IO Exception occured rendering report: " + ioe.getMessage(), ioe);
        }
        catch (Exception e) {
            Logger.getInstance().error("A problem was encountered while rendering the report: " + e.getMessage(), e);
        }
        return 1;
    }

    public static Current processArgs(String[] args) {
        Current cfg = new Current();
        cfg.setFormat(Format.DEFAULT_JSON);
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-o") || args[i].equals("--outputdir")) {
                    cfg.setOutFile(new File(args[++i]));
                    continue;
                }
                if (args[i].equals("-i") || args[i].equals("--initstring")) {
                    cfg.setInitString(args[++i]);
                    continue;
                }
                if (args[i].equals("-d") || args[i].equals("--debug")) {
                    Logger.setDebug(true);
                    continue;
                }
                if (!args[i].equals("-v") && !args[i].equals("--verbose")) continue;
                Logger.setVerbose(true);
            }
            if (!cfg.validate()) {
                JSONReporter.usage(cfg.getValidationFailureReason());
                return null;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            JSONReporter.usage("Missing a parameter.");
            return null;
        }
        return cfg;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

