/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.pdf;

import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.CloverException;
import com.cenqua.clover.CloverLicenseInfo;
import com.cenqua.clover.CloverStartup;
import com.cenqua.clover.Logger;
import com.cenqua.clover.cfg.Interval;
import com.cenqua.clover.registry.HasMetrics;
import com.cenqua.clover.registry.HasMetricsSupport;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.reporters.CloverReportConfig;
import com.cenqua.clover.reporters.Current;
import com.cenqua.clover.reporters.Format;
import com.cenqua.clover.reporters.Historical;
import com.cenqua.clover.reporters.pdf.PDFColours;
import com.cenqua.clover.reporters.pdf.PageFooterRenderer;
import com.cenqua.clover.reporters.pdf.RenderingSupport;
import com.cenqua.clover.reporters.util.HistoricalReportDescriptor;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

public class PDFReporter {
    private Document document;
    private PDFColours colours;
    private String reportTitle;
    private String titleAnchor;
    private Rectangle docsize;
    private static final Map SUPPORTED_PAGE_SIZES = new HashMap();
    private static final Rectangle DEFAULT_PAGE_SIZE;
    static /* synthetic */ Class class$com$cenqua$clover$reporters$pdf$PDFReporter;

    private Rectangle getConfiguredPageSize(CloverReportConfig cfg) {
        Rectangle size;
        String sizeStr = cfg.getFormat().getPageSize();
        if (sizeStr != null) {
            size = (Rectangle)SUPPORTED_PAGE_SIZES.get(sizeStr);
            if (size == null) {
                Logger.getInstance().warn("Unsupported Page Size '" + sizeStr + "', using default.");
                size = DEFAULT_PAGE_SIZE;
            }
        } else {
            size = DEFAULT_PAGE_SIZE;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateReport(CloverReportConfig cfg, CloverReportConfig[] secondaryReports) throws CloverException {
        PDFReporter report = new PDFReporter(cfg);
        report.open();
        try {
            report.write(cfg);
            for (int i = 0; i < secondaryReports.length; ++i) {
                CloverReportConfig secondaryCfg = secondaryReports[i];
                if (!secondaryCfg.validate()) {
                    throw new CloverException(secondaryCfg.getValidationFailureReason());
                }
                report.write(secondaryCfg);
            }
        }
        finally {
            report.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateReport(CloverReportConfig cfg) throws CloverException {
        PDFReporter report = new PDFReporter(cfg);
        report.open();
        try {
            report.write(cfg);
        }
        finally {
            report.close();
        }
    }

    private PDFReporter(CloverReportConfig cfg) throws CloverException {
        try {
            this.reportTitle = cfg.getTitle();
            this.titleAnchor = cfg.getTitleAnchor() != null ? cfg.getTitleAnchor() : "";
            this.colours = cfg.getFormat().getBw() ? PDFColours.BW_COLOURS : PDFColours.COL_COLOURS;
            this.docsize = this.getConfiguredPageSize(cfg);
            this.document = new Document(this.docsize, 25.0f, 25.0f, 25.0f, 35.0f);
            this.document.addTitle("Clover Coverage Report");
            this.document.addCreator("Clover 2.2.0 using iText v0.96");
            PdfWriter writer = PdfWriter.getInstance(this.document, new FileOutputStream(cfg.getOutFile()));
            writer.setPageEvent(new PageFooterRenderer(this.docsize, System.currentTimeMillis(), this.colours));
        }
        catch (DocumentException de) {
            throw new CloverException("Report rendering error: " + de.getMessage());
        }
        catch (IOException ioe) {
            throw new CloverException("IO Exception: " + ioe.getMessage());
        }
    }

    private void open() {
        this.document.open();
    }

    private void close() {
        this.document.close();
    }

    private void write(CloverReportConfig config) throws CloverException {
        block6: {
            try {
                if (config instanceof Current) {
                    CloverStartup.permsCheck(8L);
                    CloverDatabase db = config.getCoverageDatabase();
                    if (!config.isAlwaysReport() && db.getNumRecordingsUsed() == 0) {
                        Logger.getInstance().warn("No coverage recordings found. No report will be generated.");
                        return;
                    }
                    this.generateCurrentReport((Current)config, db);
                    break block6;
                }
                if (config instanceof Historical) {
                    CloverStartup.permsCheck(32L);
                    this.generateHistoricalReport((Historical)config);
                    break block6;
                }
                throw new CloverException("Unknown report type specified");
            }
            catch (DocumentException de) {
                throw new CloverException("Report rendering error: " + de.getMessage());
            }
            catch (IOException ioe) {
                throw new CloverException("IO Exception: " + ioe.getMessage());
            }
        }
    }

    private void newPage() throws DocumentException, IOException {
        this.document.newPage();
        this.document.add(RenderingSupport.createHistoricalPageHeader(this.reportTitle, this.titleAnchor, this.colours));
        if (CloverLicenseInfo.EXPIRED && CloverLicenseInfo.VERBOSE) {
            this.document.add(RenderingSupport.createLicenseWarningBar("Helvetica", 10, this.colours));
        } else {
            this.document.add(RenderingSupport.getSpacerRow());
        }
    }

    private void generateHistoricalReport(Historical hist) throws CloverException, DocumentException, IOException {
        HistoricalReportDescriptor desc = new HistoricalReportDescriptor(hist);
        boolean hasHistoricalData = desc.gatherHistoricalModels();
        if (!hasHistoricalData) {
            Logger.getInstance().warn("No historical data found. No PDF historical report can be generated.");
            return;
        }
        this.document.add(RenderingSupport.createHistoricalReportHeader(desc.getSubjectMetrics(), desc.getFirstTimestamp(), desc.getLastTimestamp(), this.reportTitle, this.titleAnchor, !desc.isPackageLevel(), this.colours));
        if (CloverLicenseInfo.EXPIRED) {
            this.document.add(RenderingSupport.createLicenseWarningBar("Helvetica", 10, this.colours));
        } else {
            this.document.add(RenderingSupport.getSpacerRow());
        }
        if (desc.showOverview()) {
            LinkedList<HasMetrics> parentItem = new LinkedList<HasMetrics>();
            parentItem.add(desc.getSubjectMetrics());
            this.document.add(RenderingSupport.createCoverageDataTable(hist, desc.getSubjectName(), parentItem, this.colours));
            this.document.add(RenderingSupport.getSpacerRow());
        }
        int chartsOnPage = 0;
        List charts = hist.getCharts();
        SortedMap data = desc.getHistoricalModels();
        int numCharts = charts.size();
        for (int i = 0; i < numCharts; ++i) {
            if (chartsOnPage == 2) {
                this.newPage();
                chartsOnPage = 0;
            }
            Historical.Chart coverage = (Historical.Chart)charts.get(i);
            coverage.setHeight((int)(0.33f * this.docsize.height()));
            this.document.add(RenderingSupport.createChart(coverage, data, this.colours));
            this.document.add(RenderingSupport.getSpacerRow());
            ++chartsOnPage;
        }
        if (desc.showMovers()) {
            if (chartsOnPage == 2) {
                this.newPage();
                chartsOnPage = 0;
            }
            Iterator iter = desc.getMoversDescriptors().iterator();
            while (iter.hasNext()) {
                this.document.add(RenderingSupport.createMoversTable((HistoricalReportDescriptor.MoversDescriptor)iter.next(), this.colours));
                if (!iter.hasNext()) continue;
                this.document.add(RenderingSupport.getSpacerRow());
            }
        }
        this.document.newPage();
    }

    private void generateCurrentReport(Current currentConfig, CloverDatabase db) throws CloverException, DocumentException {
        ProjectInfo project = db.getModel();
        Logger.getInstance().debug("creating project summary report");
        ProjectInfo parent = project;
        List children = project.getPackages();
        Logger.getInstance().debug("num packages = " + children.size());
        String parentTitle = "";
        String childrenTitle = "Packages";
        this.document.add(RenderingSupport.createReportHeader(project, db.getRecordingTimestamp(), this.reportTitle, this.titleAnchor, this.colours));
        if (CloverLicenseInfo.EXPIRED) {
            this.document.add(RenderingSupport.createLicenseWarningBar("Helvetica", 10, this.colours));
        } else {
            this.document.add(RenderingSupport.getSpacerRow());
        }
        ArrayList<ProjectInfo> tmp = new ArrayList<ProjectInfo>();
        tmp.add(parent);
        this.document.add(RenderingSupport.createCoverageDataTable(currentConfig, parentTitle, tmp, this.colours));
        this.document.add(RenderingSupport.getSpacerRow());
        Collections.sort(children, HasMetricsSupport.getHasMetricsComparator(currentConfig.getFormat().getOrderby()));
        this.document.add(RenderingSupport.createCoverageDataTable(currentConfig, childrenTitle, children, this.colours));
        this.document.newPage();
    }

    public static void main(String[] args) {
        System.exit(PDFReporter.mainImpl(args));
    }

    public static int mainImpl(String[] args) {
        CloverStartup.loadLicense(Logger.getInstance());
        CloverReportConfig cfg = PDFReporter.processArgs(args);
        if (cfg == null) {
            return 1;
        }
        try {
            PDFReporter.generateReport(cfg);
            return 0;
        }
        catch (Exception e) {
            Logger.getInstance().error("A problem was encountered while rendering the report: " + e.getMessage(), e);
            return 1;
        }
    }

    private static CloverReportConfig processArgs(String[] args) {
        Current cfg = Current.DEFAULT_PDF;
        cfg.setFormat(Format.DEFAULT_PDF);
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-o") || args[i].equals("--outputfile")) {
                    cfg.setOutFile(new File(args[++i]));
                    continue;
                }
                if (args[i].equals("-i") || args[i].equals("--initstring")) {
                    cfg.setInitString(args[++i]);
                    continue;
                }
                if (args[i].equals("-t") || args[i].equals("--title")) {
                    cfg.setTitle(args[++i]);
                    continue;
                }
                if (args[i].equals("-p") || args[i].equals("--pagesize")) {
                    cfg.getFormat().setPageSize(args[++i]);
                    continue;
                }
                if (args[i].equals("-b") || args[i].equals("--hidebars")) {
                    cfg.getFormat().setShowBars(false);
                    continue;
                }
                if (args[i].equals("-e") || args[i].equals("--showempty")) {
                    cfg.getFormat().setShowEmpty(true);
                    continue;
                }
                if (args[i].equals("-s") || args[i].equals("--span")) {
                    ++i;
                    try {
                        cfg.setSpan(new Interval(args[i]));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        PDFReporter.usage("Invalid interval format. Should be integer followed by unit (s, m, h, d, w).");
                        return null;
                    }
                }
                if (args[i].equals("-c") || args[i].equals("--orderby")) {
                    cfg.getFormat().setOrderby(args[++i]);
                    continue;
                }
                if (args[i].equals("-d") || args[i].equals("--debug")) {
                    Logger.setDebug(true);
                    continue;
                }
                if (args[i].equals("-v") || args[i].equals("--verbose")) {
                    Logger.setVerbose(true);
                    continue;
                }
                if (!args[i].equals("-l") && !args[i].equals("--ignore")) continue;
                ++i;
            }
            if (!((CloverReportConfig)cfg).validate()) {
                PDFReporter.usage(cfg.getValidationFailureReason());
                cfg = null;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            PDFReporter.usage("Missing a parameter.");
            cfg = null;
        }
        return cfg;
    }

    private static void usage(String msg) {
        System.err.println();
        if (msg != null) {
            System.err.println("  *** ERROR: " + msg);
        }
        System.err.println();
        System.err.println("  USAGE: " + (class$com$cenqua$clover$reporters$pdf$PDFReporter == null ? (class$com$cenqua$clover$reporters$pdf$PDFReporter = PDFReporter.class$("com.cenqua.clover.reporters.pdf.PDFReporter")) : class$com$cenqua$clover$reporters$pdf$PDFReporter).getName() + " [OPTIONS] PARAMS\n\n" + "  PARAMS:\n" + "    -i, --initstring <string>\tclover initstring\n\n" + "    -o, --outputfile <file>\tfile to write PDF to.\n\n" + "  OPTIONS:\n" + "    -t, --title <string>\treport title.\n\n" + "    -e, --showempty\t\tshow classes/packages even if they don't have any\n" + "\t\t\t\tstatements, methods or conditionals. default is false\n\n" + "    -b, --hidebars\t\tdon't render coverage bars. default is false.\n\n" + "    -p, --pagesize <size>\tPage size to use. Valid values are \"A4\",\"Letter\". Default is \"A4\".\n\n" + "    -s, --span <interval>\tSpecifies how far back in time to\n" + "\t\t\t\tinclude coverage recordings from since the last Clover build. In Interval\n" + "\t\t\t\tformat. \"60s\" = 60 seconds, \"1h\" = 1 hour, \"1d\" = 1 day etc.\n\n" + "    -d, --debug \t\tswitch logging level to debug\n\n" + "    -v, --verbose \t\tswitch logging level to verbose\n\n" + "    -l, --ignore <string>\tcomma or space separated list of blocks to ignore\n" + "\t\t\t\twhen generating coverage reports. Most useful one is \"catch\".\n" + "\t\t\t\tvalid values are \"static\",\"instance\",\"constructor\",\"method\",\"switch\",\n" + "\t\t\t\t\"while\",\"do\",\"for\",\"if\",\"else\",\"try\",\"catch\",\"finally\",\"sync\"\n\n" + "    -c, --orderby <compname>\tcomparator to use when listing packages and classes.\n" + "\t\t\t\tvalid values are \"alpha\" - alphabetic, \"desc\" - coverage descending,\n" + "\t\t\t\t\"asc\" - coverage ascending. default is \"asc\".\n\n");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SUPPORTED_PAGE_SIZES.put("A4", PageSize.A4);
        SUPPORTED_PAGE_SIZES.put("LETTER", PageSize.LETTER);
        DEFAULT_PAGE_SIZE = PageSize.A4;
    }
}

