/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.tasks;

import com.cenqua.clover.CloverException;
import com.cenqua.clover.context.ContextRegistry;
import com.cenqua.clover.context.MethodRegexpContext;
import com.cenqua.clover.context.RegexpContext;
import com.cenqua.clover.context.StatementRegexpContext;
import com.cenqua.clover.registry.Clover2Registry;
import com.cenqua.clover.tasks.AbstractCloverTask;
import com.cenqua.clover.tasks.AntInstrumentationConfig;
import com.cenqua.clover.tasks.TestSourceSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;

public abstract class AbstractInstrTask
extends AbstractCloverTask {
    protected AntInstrumentationConfig.FlushPolicy flushPolicy;
    protected AntInstrumentationConfig.Instrumentation instrumentation;
    protected List instrFilesets = null;
    protected List methodContexts = null;
    protected List statementContexts = null;
    protected List testSources = null;

    public void setReportInitErrors(boolean reportInitErrors) {
        this.config.setReportInitErrors(reportInitErrors);
    }

    public void setSource(String source) {
        this.config.setSourceLevel(source);
    }

    public void setFullyQualifyJavaLang(boolean fullyQualify) {
        this.config.setFullyQualifyJavaLang(fullyQualify);
    }

    public void setRecordTestResults(boolean record) {
        this.config.setTestRewriting(record);
    }

    public String getRuntimeInitString() {
        try {
            return this.config.getRuntimeInitString();
        }
        catch (CloverException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    public void setEncoding(String encoding) {
        this.config.setEncoding(encoding);
    }

    public void setRelative(boolean relative) {
        this.config.setRelative(relative);
    }

    public void setFlushInterval(int flushInterval) {
        this.config.setFlushInterval(flushInterval);
    }

    public void setFlushPolicy(AntInstrumentationConfig.FlushPolicy flushPolicy) {
        this.flushPolicy = flushPolicy;
    }

    public void setInstrumentation(AntInstrumentationConfig.Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
    }

    public void addFileset(FileSet set) {
        if (this.instrFilesets == null) {
            this.instrFilesets = new ArrayList();
        }
        this.instrFilesets.add(set);
    }

    public void addConfiguredTestSources(TestSourceSet ts) {
        if (this.testSources == null) {
            this.testSources = new ArrayList();
        }
        ts.validate();
        this.testSources.add(ts);
    }

    public void addMethodContext(MethodContextDef context) {
        if (this.methodContexts == null) {
            this.methodContexts = new ArrayList();
        }
        this.methodContexts.add(context);
    }

    public void addStatementContext(StatementContextDef context) {
        if (this.statementContexts == null) {
            this.statementContexts = new ArrayList();
        }
        this.statementContexts.add(context);
    }

    public boolean validate() {
        if (this.flushPolicy != null) {
            try {
                this.config.setFlushPolicyFromString(this.flushPolicy.getValue());
                if (this.config.isIntervalBasedFlushing() && this.config.getFlushInterval() == 0) {
                    throw new BuildException("You must set a flushinterval > 0 when using '" + this.flushPolicy.getValue() + "' flushpolicy.");
                }
            }
            catch (CloverException e) {
                throw new BuildException(e.getMessage());
            }
        }
        if (this.instrumentation != null) {
            this.config.setInstrStrategy(this.instrumentation.getValue());
        }
        if (this.methodContexts != null || this.statementContexts != null) {
            Clover2Registry registry;
            RegexpContext context;
            StatementContextDef contextDef;
            Iterator it;
            ContextRegistry contexts = new ContextRegistry();
            if (this.methodContexts != null) {
                it = this.methodContexts.iterator();
                while (it.hasNext()) {
                    contextDef = (MethodContextDef)it.next();
                    ((MethodContextDef)contextDef).validate();
                    try {
                        context = new MethodRegexpContext(contextDef.getName(), Pattern.compile(contextDef.getRegexp()), ((MethodContextDef)contextDef).getMaxComplexity());
                        contexts.addMethodContext((MethodRegexpContext)context);
                    }
                    catch (PatternSyntaxException e) {
                        throw new BuildException("Invalid context definition: " + e.getMessage());
                    }
                    catch (CloverException e) {
                        throw new BuildException("Problem adding context: " + e.getMessage());
                    }
                }
            }
            if (this.statementContexts != null) {
                it = this.statementContexts.iterator();
                while (it.hasNext()) {
                    contextDef = (StatementContextDef)it.next();
                    contextDef.validate();
                    try {
                        context = new StatementRegexpContext(contextDef.getName(), Pattern.compile(contextDef.getRegexp()));
                        contexts.addStatementContext((StatementRegexpContext)context);
                    }
                    catch (PatternSyntaxException e) {
                        throw new BuildException("Invalid context definition: " + e.getMessage());
                    }
                    catch (CloverException e) {
                        throw new BuildException("Problem adding context: " + e.getMessage());
                    }
                }
            }
            try {
                registry = Clover2Registry.createOrLoad(this.config.getRegistryFile(), this.config.getProjectName());
            }
            catch (IOException e) {
                throw new BuildException(e.getClass().getName() + " accessing Clover database: " + e.getMessage());
            }
            catch (CloverException e) {
                throw new BuildException(e.getMessage());
            }
            registry.setContextRegistry(contexts);
            try {
                registry.store();
            }
            catch (IOException e) {
                throw new BuildException(e.getClass().getName() + " writing Clover database: " + e.getMessage());
            }
        }
        return true;
    }

    public static class MethodContextDef
    extends StatementContextDef {
        private int maxComplexity = Integer.MAX_VALUE;

        public int getMaxComplexity() {
            return this.maxComplexity;
        }

        public void setMaxComplexity(int maxComplexity) {
            this.maxComplexity = maxComplexity;
        }

        protected void validate() throws BuildException {
            if (this.maxComplexity < 0) {
                throw new BuildException("maxComplexity must be greater than 0");
            }
            if (this.maxComplexity == 0) {
                throw new BuildException("A maxComplexity of 0 doesn't make sense, because methods have a minimum complexity of 1");
            }
            if (this.getRegexp() == null || this.getRegexp().trim().length() == 0) {
                this.setRegexp(".*");
            }
            super.validate();
        }
    }

    public static class StatementContextDef {
        private String name;
        private String regexp;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRegexp() {
            return this.regexp;
        }

        public void setRegexp(String regexp) {
            this.regexp = regexp;
        }

        protected void validate() throws BuildException {
            if (this.name == null || this.name.trim().length() == 0) {
                throw new BuildException("Context definition requires a name");
            }
            if (this.regexp == null || this.regexp.trim().length() == 0) {
                throw new BuildException("Context definition requires a regular expression");
            }
        }
    }
}

