/*
 * Decompiled with CFR 0.152.
 */
package com.keypoint;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PngEncoder {
    public static final boolean ENCODE_ALPHA = true;
    public static final boolean NO_ALPHA = false;
    public static final int FILTER_NONE = 0;
    public static final int FILTER_SUB = 1;
    public static final int FILTER_UP = 2;
    public static final int FILTER_LAST = 2;
    protected static final byte[] IHDR = new byte[]{73, 72, 68, 82};
    protected static final byte[] IDAT = new byte[]{73, 68, 65, 84};
    protected static final byte[] IEND = new byte[]{73, 69, 78, 68};
    protected static final byte[] PHYS = new byte[]{112, 72, 89, 115};
    protected byte[] pngBytes;
    protected byte[] priorRow;
    protected byte[] leftBytes;
    protected Image image;
    protected int width;
    protected int height;
    protected int bytePos;
    protected int maxPos;
    protected CRC32 crc = new CRC32();
    protected long crcValue;
    protected boolean encodeAlpha;
    protected int filter;
    protected int bytesPerPixel;
    private int xDpi = 0;
    private int yDpi = 0;
    private static float INCH_IN_METER_UNIT = 0.0254f;
    protected int compressionLevel;

    public PngEncoder() {
        this(null, false, 0, 0);
    }

    public PngEncoder(Image image) {
        this(image, false, 0, 0);
    }

    public PngEncoder(Image image, boolean encodeAlpha) {
        this(image, encodeAlpha, 0, 0);
    }

    public PngEncoder(Image image, boolean encodeAlpha, int whichFilter) {
        this(image, encodeAlpha, whichFilter, 0);
    }

    public PngEncoder(Image image, boolean encodeAlpha, int whichFilter, int compLevel) {
        this.image = image;
        this.encodeAlpha = encodeAlpha;
        this.setFilter(whichFilter);
        if (compLevel >= 0 && compLevel <= 9) {
            this.compressionLevel = compLevel;
        }
    }

    public void setImage(Image image) {
        this.image = image;
        this.pngBytes = null;
    }

    public Image getImage() {
        return this.image;
    }

    public byte[] pngEncode(boolean encodeAlpha) {
        byte[] pngIdBytes = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        if (this.image == null) {
            return null;
        }
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
        this.pngBytes = new byte[(this.width + 1) * this.height * 3 + 200];
        this.maxPos = 0;
        this.bytePos = this.writeBytes(pngIdBytes, 0);
        this.writeHeader();
        this.writeResolution();
        if (this.writeImageData()) {
            this.writeEnd();
            this.pngBytes = this.resizeByteArray(this.pngBytes, this.maxPos);
        } else {
            this.pngBytes = null;
        }
        return this.pngBytes;
    }

    public byte[] pngEncode() {
        return this.pngEncode(this.encodeAlpha);
    }

    public void setEncodeAlpha(boolean encodeAlpha) {
        this.encodeAlpha = encodeAlpha;
    }

    public boolean getEncodeAlpha() {
        return this.encodeAlpha;
    }

    public void setFilter(int whichFilter) {
        this.filter = 0;
        if (whichFilter <= 2) {
            this.filter = whichFilter;
        }
    }

    public int getFilter() {
        return this.filter;
    }

    public void setCompressionLevel(int level) {
        if (level >= 0 && level <= 9) {
            this.compressionLevel = level;
        }
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    protected byte[] resizeByteArray(byte[] array, int newLength) {
        byte[] newArray = new byte[newLength];
        int oldLength = array.length;
        System.arraycopy(array, 0, newArray, 0, Math.min(oldLength, newLength));
        return newArray;
    }

    protected int writeBytes(byte[] data, int offset) {
        this.maxPos = Math.max(this.maxPos, offset + data.length);
        if (data.length + offset > this.pngBytes.length) {
            this.pngBytes = this.resizeByteArray(this.pngBytes, this.pngBytes.length + Math.max(1000, data.length));
        }
        System.arraycopy(data, 0, this.pngBytes, offset, data.length);
        return offset + data.length;
    }

    protected int writeBytes(byte[] data, int nBytes, int offset) {
        this.maxPos = Math.max(this.maxPos, offset + nBytes);
        if (nBytes + offset > this.pngBytes.length) {
            this.pngBytes = this.resizeByteArray(this.pngBytes, this.pngBytes.length + Math.max(1000, nBytes));
        }
        System.arraycopy(data, 0, this.pngBytes, offset, nBytes);
        return offset + nBytes;
    }

    protected int writeInt2(int n, int offset) {
        byte[] temp = new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return this.writeBytes(temp, offset);
    }

    protected int writeInt4(int n, int offset) {
        byte[] temp = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return this.writeBytes(temp, offset);
    }

    protected int writeByte(int b, int offset) {
        byte[] temp = new byte[]{(byte)b};
        return this.writeBytes(temp, offset);
    }

    protected void writeHeader() {
        int startPos = this.bytePos = this.writeInt4(13, this.bytePos);
        this.bytePos = this.writeBytes(IHDR, this.bytePos);
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
        this.bytePos = this.writeInt4(this.width, this.bytePos);
        this.bytePos = this.writeInt4(this.height, this.bytePos);
        this.bytePos = this.writeByte(8, this.bytePos);
        this.bytePos = this.writeByte(this.encodeAlpha ? 6 : 2, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.bytePos = this.writeByte(0, this.bytePos);
        this.crc.reset();
        this.crc.update(this.pngBytes, startPos, this.bytePos - startPos);
        this.crcValue = this.crc.getValue();
        this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
    }

    protected void filterSub(byte[] pixels, int startPos, int width) {
        int offset = this.bytesPerPixel;
        int actualStart = startPos + offset;
        int nBytes = width * this.bytesPerPixel;
        int leftInsert = offset;
        int leftExtract = 0;
        for (int i = actualStart; i < startPos + nBytes; ++i) {
            this.leftBytes[leftInsert] = pixels[i];
            pixels[i] = (byte)((pixels[i] - this.leftBytes[leftExtract]) % 256);
            leftInsert = (leftInsert + 1) % 15;
            leftExtract = (leftExtract + 1) % 15;
        }
    }

    protected void filterUp(byte[] pixels, int startPos, int width) {
        int nBytes = width * this.bytesPerPixel;
        for (int i = 0; i < nBytes; ++i) {
            byte currentByte = pixels[startPos + i];
            pixels[startPos + i] = (byte)((pixels[startPos + i] - this.priorRow[i]) % 256);
            this.priorRow[i] = currentByte;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean writeImageData() {
        int startRow = 0;
        this.bytesPerPixel = this.encodeAlpha ? 4 : 3;
        Deflater deflater = new Deflater(this.compressionLevel);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
        try {
            void startPos;
            for (int rowsLeft = this.height; rowsLeft > 0; rowsLeft -= startPos) {
                void scanPos;
                int n = Math.min(Short.MAX_VALUE / (this.width * (this.bytesPerPixel + 1)), rowsLeft);
                n = Math.max(n, 1);
                int[] nArray = new int[this.width * n];
                PixelGrabber pixelGrabber = new PixelGrabber(this.image, 0, startRow, this.width, n, nArray, 0, this.width);
                try {
                    pixelGrabber.grabPixels();
                }
                catch (Exception pg) {
                    System.err.println("interrupted waiting for pixels!");
                    return false;
                }
                if ((pixelGrabber.getStatus() & 0x80) != 0) {
                    System.err.println("image fetch aborted or errored");
                    return false;
                }
                byte[] scrunch = new byte[this.width * n * this.bytesPerPixel + n];
                if (this.filter == 1) {
                    this.leftBytes = new byte[16];
                }
                if (this.filter == 2) {
                    this.priorRow = new byte[this.width * this.bytesPerPixel];
                }
                int outBytes = 0;
                int compBytes = 1;
                for (int pg = 0; pg < this.width * startPos; ++pg) {
                    if (pg % this.width == 0) {
                        scrunch[outBytes++] = (byte)this.filter;
                        compBytes = outBytes;
                    }
                    scrunch[outBytes++] = (byte)(nArray[pg] >> 16 & 0xFF);
                    scrunch[outBytes++] = (byte)(nArray[pg] >> 8 & 0xFF);
                    scrunch[outBytes++] = (byte)(nArray[pg] & 0xFF);
                    if (this.encodeAlpha) {
                        scrunch[outBytes++] = (byte)(nArray[pg] >> 24 & 0xFF);
                    }
                    if (pg % this.width != this.width - 1 || this.filter == 0) continue;
                    if (this.filter == 1) {
                        this.filterSub(scrunch, compBytes, this.width);
                    }
                    if (this.filter != 2) continue;
                    this.filterUp(scrunch, compBytes, this.width);
                }
                scanPos.write(scrunch, 0, outBytes);
                startRow += startPos;
            }
            deflaterOutputStream.close();
            byte[] pixels = byteArrayOutputStream.toByteArray();
            int n = pixels.length;
            this.crc.reset();
            this.bytePos = this.writeInt4(n, this.bytePos);
            this.bytePos = this.writeBytes(IDAT, this.bytePos);
            this.crc.update(IDAT);
            this.bytePos = this.writeBytes(pixels, n, this.bytePos);
            this.crc.update(pixels, 0, n);
            this.crcValue = this.crc.getValue();
            this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
            deflater.finish();
            return true;
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
            return false;
        }
    }

    protected void writeEnd() {
        this.bytePos = this.writeInt4(0, this.bytePos);
        this.bytePos = this.writeBytes(IEND, this.bytePos);
        this.crc.reset();
        this.crc.update(IEND);
        this.crcValue = this.crc.getValue();
        this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
    }

    public void setXDpi(int xDpi) {
        this.xDpi = Math.round((float)xDpi / INCH_IN_METER_UNIT);
    }

    public int getXDpi() {
        return Math.round((float)this.xDpi * INCH_IN_METER_UNIT);
    }

    public void setYDpi(int yDpi) {
        this.yDpi = Math.round((float)yDpi / INCH_IN_METER_UNIT);
    }

    public int getYDpi() {
        return Math.round((float)this.yDpi * INCH_IN_METER_UNIT);
    }

    public void setDpi(int xDpi, int yDpi) {
        this.xDpi = Math.round((float)xDpi / INCH_IN_METER_UNIT);
        this.yDpi = Math.round((float)yDpi / INCH_IN_METER_UNIT);
    }

    protected void writeResolution() {
        if (this.xDpi > 0 && this.yDpi > 0) {
            int startPos = this.bytePos = this.writeInt4(9, this.bytePos);
            this.bytePos = this.writeBytes(PHYS, this.bytePos);
            this.bytePos = this.writeInt4(this.xDpi, this.bytePos);
            this.bytePos = this.writeInt4(this.yDpi, this.bytePos);
            this.bytePos = this.writeByte(1, this.bytePos);
            this.crc.reset();
            this.crc.update(this.pngBytes, startPos, this.bytePos - startPos);
            this.crcValue = this.crc.getValue();
            this.bytePos = this.writeInt4((int)this.crcValue, this.bytePos);
        }
    }
}

