/*
 * Decompiled with CFR 0.152.
 */
package com_cenqua_clover;

import com.cenqua.clover.Logger;
import com.cenqua.clover.RecorderLogging;
import com.cenqua.clover.registry.Clover2Registry;
import com_cenqua_clover.CoverageRecorder;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class Clover {
    public static final int NO_SLICE = -1;
    private static int currentSlice = -1;
    private static long currentSliceStart = 0L;
    private static Class currentType;
    private static Map typeIDs;
    private static final HashMap sRecorders;
    private static final CoverageRecorder dummyRecorder;
    private static int typeID;
    public static final int SLICE_START = 0;
    public static final int SLICE_END = 1;
    public static final String[] SLICE_TYPE;

    private Clover() {
    }

    public static void globalFlush() {
        Clover.allRecordersFlush();
    }

    public static int getCurrentSlice() {
        return currentSlice;
    }

    public static Class getCurrentType() {
        return currentType;
    }

    public static long getCurrentSliceStart() {
        return currentSliceStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CoverageRecorder getRecorder(char[] initChars, long dbVersion, long cfgbits, int maxDataIndex) {
        String initStr = new String(initChars);
        String recorderKey = initStr + "_" + dbVersion + "_" + cfgbits;
        HashMap hashMap = sRecorders;
        synchronized (hashMap) {
            CoverageRecorder recorder = (CoverageRecorder)sRecorders.get(recorderKey);
            if (recorder != null) {
                Logger.getInstance().debug("[found existing recorder for " + recorderKey + "]");
            } else {
                Logger.getInstance().debug("[creating new recorder for " + recorderKey + "]");
                recorder = Clover.createRecorder(initStr, dbVersion, cfgbits);
                sRecorders.put(recorderKey, recorder);
                recorder.startRun();
            }
            if (recorder.getNumElements() < maxDataIndex) {
                Logger.getInstance().warn("CLOVER: Clover database: '" + initStr + "' is no longer valid. Required size: " + maxDataIndex + ", actual size: " + recorder.getNumElements());
                Logger.getInstance().warn("CLOVER: No coverage data will be gathered.");
                dummyRecorder.growToSize(maxDataIndex);
                return dummyRecorder;
            }
            return recorder;
        }
    }

    public static int getTypeID(Class runtimeType) {
        int result;
        Integer val = (Integer)typeIDs.get(runtimeType);
        if (val == null) {
            result = typeID++;
            typeIDs.put(runtimeType, new Integer(result));
        } else {
            result = val;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void allRecordersFlush() {
        HashMap hashMap = sRecorders;
        synchronized (hashMap) {
            Iterator recorders = sRecorders.values().iterator();
            while (recorders.hasNext()) {
                CoverageRecorder recorder = (CoverageRecorder)recorders.next();
                recorder.forceFlush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void allRecordersSliceStart(Class type, int slice) {
        HashMap hashMap = sRecorders;
        synchronized (hashMap) {
            currentSlice = slice;
            currentSliceStart = System.currentTimeMillis();
            currentType = type;
            Iterator recorders = sRecorders.values().iterator();
            while (recorders.hasNext()) {
                CoverageRecorder recorder = (CoverageRecorder)recorders.next();
                recorder.sliceStart(type, currentSliceStart, slice);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void allRecordersSliceEnd(Class type, String method, int slice, int p, Throwable t) {
        HashMap hashMap = sRecorders;
        synchronized (hashMap) {
            currentSlice = -1;
            long ts = System.currentTimeMillis();
            Iterator recorders = sRecorders.values().iterator();
            while (recorders.hasNext()) {
                CoverageRecorder recorder = (CoverageRecorder)recorders.next();
                recorder.sliceEnd(type, method, ts, slice, p, t);
            }
        }
    }

    public static CoverageRecorder createRecorder(String dbName, long dbVersion, long cfgbits) {
        try {
            File infile = Clover.resolveRegistryFile(dbName);
            int numElements = Clover2Registry.readRegistryHeaderAndModeOnly(infile);
            return new CoverageRecorder(infile.getAbsolutePath(), dbVersion, numElements, cfgbits);
        }
        catch (IOException ioe) {
            Logger.getInstance().error("CLOVER: Unable to load coverage database.");
            Logger.getInstance().error("CLOVER: No coverage data will be gathered.");
            Logger.getInstance().error("CLOVER: " + ioe.getClass().getName());
            Logger.getInstance().error("CLOVER: " + ioe.getMessage());
            return new CoverageRecorder(null, 0L, 500000, cfgbits);
        }
    }

    private static File resolveRegistryFile(String dbName) {
        try {
            String initStringProp = System.getProperty("clover.initstring");
            if (initStringProp != null && initStringProp.length() > 0) {
                Logger.getInstance().verbose("overriding initstring: " + initStringProp);
                return new File(initStringProp);
            }
            String initStringBaseProp = System.getProperty("clover.initstring.basedir");
            if (initStringBaseProp != null && initStringBaseProp.length() > 0) {
                Logger.getInstance().verbose("overriding initstring basedir: " + initStringBaseProp);
                File dbFile = new File(dbName);
                return new File(initStringBaseProp, dbFile.getName());
            }
            String initStringPrefixProp = System.getProperty("clover.initstring.prefix");
            if (initStringPrefixProp != null && initStringPrefixProp.length() > 0) {
                Logger.getInstance().verbose("prepending initstring prefix: " + initStringPrefixProp);
                String newInit = initStringPrefixProp + dbName;
                if ((initStringPrefixProp.endsWith("/") || initStringPrefixProp.endsWith("\\")) && (dbName.startsWith("\\") || dbName.startsWith("/"))) {
                    newInit = initStringPrefixProp + dbName.substring(1);
                }
                return new File(newInit);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return new File(dbName);
    }

    public static String getRecordingName(int hash, String dbname, long ts) {
        return dbname + Integer.toString(hash, 36) + "_" + Long.toString(ts, 36);
    }

    public static String getRecordingName(int typeid, int slice, int rectype, int hash, String dbname, long ts) {
        long globalSliceID = (long)typeid << 32 | (long)slice;
        return dbname + Long.toString(globalSliceID, 36) + "_" + SLICE_TYPE[rectype] + Integer.toString(hash, 36) + "_" + Long.toString(ts, 36);
    }

    public static void l(String m) {
        Logger.getInstance().error(m);
    }

    public static void l(String m, Throwable t) {
        Logger.getInstance().error(m, t);
    }

    static {
        RecorderLogging.init();
        typeIDs = Collections.synchronizedMap(new HashMap());
        sRecorders = new HashMap();
        dummyRecorder = new CoverageRecorder(null, 0L, 50000, 0L);
        typeID = 0;
        SLICE_TYPE = new String[]{"X", "Y"};
    }
}

