/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.osuser;

import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.service.UserManager;
import com.atlassian.crowd.integration.service.cache.CacheExpiryManager;
import com.atlassian.crowd.integration.service.cache.CachingManagerFactory;
import com.atlassian.crowd.integration.util.Null;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import com.opensymphony.user.Entity;
import com.opensymphony.user.provider.ProfileProvider;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class CrowdProfileProvider
implements ProfileProvider {
    protected final Logger logger = Logger.getLogger(this.getClass());
    private final UserManager userManager;
    private final CacheExpiryManager cacheExpiryManager;
    public static final String PROPERTY_NAME_KEY = "name";
    protected final String ssoPropertySetName = "crowd";

    public CrowdProfileProvider() {
        this(CachingManagerFactory.getUserManagerInstance(), CachingManagerFactory.getCacheExpiryManagerInstance());
    }

    public CrowdProfileProvider(UserManager userManager, CacheExpiryManager cacheExpiryManager) {
        this.userManager = userManager;
        this.cacheExpiryManager = cacheExpiryManager;
    }

    public PropertySet getPropertySet(String user) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put(PROPERTY_NAME_KEY, user);
        PropertySet result = PropertySetManager.getInstance((String)"crowd", args);
        return result;
    }

    public boolean handles(String name) {
        Null.not(name);
        try {
            return this.userManager.isUser(name);
        }
        catch (InvalidAuthorizationTokenException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean init(Properties properties) {
        return true;
    }

    public void flushCaches() {
        this.cacheExpiryManager.flush();
    }

    public List list() {
        List userNames = null;
        try {
            userNames = this.userManager.getAllUserNames();
        }
        catch (InvalidAuthorizationTokenException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        return userNames;
    }

    public boolean create(String name) {
        return true;
    }

    public boolean remove(String name) {
        return false;
    }

    public boolean store(String name, Entity.Accessor accessor) {
        return false;
    }

    public boolean load(String string, Entity.Accessor accessor) {
        accessor.setMutable(true);
        return true;
    }
}

