/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.osuser;

import com.atlassian.crowd.integration.exception.ApplicationPermissionException;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.service.UserManager;
import com.atlassian.crowd.integration.service.cache.CachingManagerFactory;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.util.Null;
import com.opensymphony.module.propertyset.AbstractPropertySet;
import com.opensymphony.module.propertyset.PropertyException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class CrowdPropertySet
extends AbstractPropertySet {
    private static final Logger logger = Logger.getLogger(CrowdPropertySet.class);
    private Map keys;
    private SOAPPrincipal principal;
    private final UserManager userManager;

    public CrowdPropertySet() {
        this(CachingManagerFactory.getUserManagerInstance());
    }

    public CrowdPropertySet(UserManager userManager) {
        this.userManager = userManager;
    }

    public Collection getKeys(String prefix, int type) throws PropertyException {
        ArrayList<String> foundKeys = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)prefix)) {
            for (String key : this.keys.keySet()) {
                if (!key.startsWith(prefix)) continue;
                foundKeys.add(key);
            }
        }
        return Collections.unmodifiableCollection(foundKeys);
    }

    public int getType(String key) throws PropertyException {
        if (this.exists(key)) {
            return 5;
        }
        return 0;
    }

    public void remove(String key) throws PropertyException {
        if (!this.isSettable(key)) {
            throw new PropertyException("Property with key: '" + key + "' cannot be removed");
        }
        if (this.exists(key)) {
            this.removeAttribute(this.principal, key);
            this.updateUser(this.principal);
        }
    }

    protected void removeAttribute(SOAPPrincipal user, String key) {
        Null.not(user);
        Null.not(key);
        SOAPAttribute[] existingAttributes = user.getAttributes();
        if (existingAttributes != null) {
            ArrayList<SOAPAttribute> newAttributes = new ArrayList<SOAPAttribute>(Arrays.asList(existingAttributes));
            ListIterator<SOAPAttribute> attrIt = newAttributes.listIterator();
            while (attrIt.hasNext()) {
                SOAPAttribute attribute = attrIt.next();
                if (!key.equals(attribute.getName())) continue;
                attrIt.remove();
                break;
            }
            user.setAttributes(this.convertCollectionToSOAPAttributeArray(newAttributes));
        }
    }

    private SOAPAttribute[] convertCollectionToSOAPAttributeArray(Collection col) {
        Null.not(col);
        SOAPAttribute[] attributes = new SOAPAttribute[col.size()];
        int i = 0;
        Iterator colIt = col.iterator();
        while (colIt.hasNext()) {
            attributes[i] = (SOAPAttribute)colIt.next();
            ++i;
        }
        return attributes;
    }

    public boolean exists(String property) throws PropertyException {
        return "email".equals(property) || "fullName".equals(property);
    }

    protected void setImpl(int type, String key, Object value) throws PropertyException {
        if (!this.isSettable(key)) {
            throw new PropertyException("Property with key: '" + key + "' cannot be set");
        }
        switch (type) {
            case 5: {
                this.setString(key, (String)value);
                return;
            }
            case 1: {
                this.setBoolean(key, (Boolean)value);
                return;
            }
            case 2: {
                this.setInt(key, ((Number)value).intValue());
                return;
            }
            case 3: {
                this.setLong(key, ((Number)value).longValue());
                return;
            }
            case 4: {
                this.setDouble(key, ((Number)value).doubleValue());
                return;
            }
            case 6: {
                this.setText(key, (String)value);
                return;
            }
            case 7: {
                this.setDate(key, (Date)value);
                return;
            }
            case 8: {
                this.setObject(key, value);
                return;
            }
            case 9: {
                this.setXML(key, (Document)value);
                return;
            }
            case 10: {
                this.setData(key, (byte[])value);
                return;
            }
        }
    }

    protected Object get(int type, String key) throws PropertyException {
        if (this.exists(key)) {
            switch (type) {
                case 1: {
                    boolean bool = this.getBoolean(key);
                    if (bool) {
                        return Boolean.TRUE;
                    }
                    if (!this.exists(key)) break;
                    return Boolean.FALSE;
                }
                case 2: {
                    int maybeInt = this.getInt(key);
                    if (maybeInt == 0) break;
                    return new Integer(maybeInt);
                }
                case 3: {
                    long maybeLong = this.getLong(key);
                    if (maybeLong == 0L) break;
                    return new Long(maybeLong);
                }
                case 4: {
                    double maybeDouble = this.getDouble(key);
                    if (maybeDouble == 0.0) break;
                    return new Double(maybeDouble);
                }
                case 5: {
                    String string = this.getString(key);
                    if (string == null) break;
                    return string;
                }
                case 6: {
                    String text = this.getText(key);
                    if (text == null) break;
                    return text;
                }
                case 7: {
                    Date date = this.getDate(key);
                    if (date == null) break;
                    return date;
                }
                case 8: {
                    Object obj = this.getObject(key);
                    if (obj == null) break;
                    return obj;
                }
                case 9: {
                    Document doc = this.getXML(key);
                    if (doc == null) break;
                    return doc;
                }
                case 10: {
                    byte[] data = this.getData(key);
                    if (data == null) break;
                    return data;
                }
                case 11: {
                    Properties p = this.getProperties(key);
                    if (p == null) break;
                    return p;
                }
            }
        }
        return null;
    }

    public void init(Map config, Map args) {
        try {
            this.keys = new HashMap();
            this.keys.put("email", "mail");
            this.keys.put("fullName", "displayName");
            String username = (String)args.get("name");
            this.principal = this.userManager.getUser(username);
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
        }
    }

    public boolean isSettable(String property) {
        return "email".equals(property) || "fullName".equals(property);
    }

    public void setString(String property, String value) throws PropertyException {
        if (this.isSettable(property) && StringUtils.isNotBlank((String)value)) {
            ArrayList<SOAPAttribute> newAttributes = new ArrayList<SOAPAttribute>();
            SOAPAttribute[] existingAttributes = this.principal.getAttributes();
            if (existingAttributes != null) {
                newAttributes.addAll(Arrays.asList(existingAttributes));
            }
            if ("fullName".equals(property)) {
                newAttributes.addAll(this.splitFullnameIntoSOAPAttributes(value));
            } else {
                newAttributes.add(new SOAPAttribute((String)this.keys.get(property), value));
            }
            this.principal.setAttributes(newAttributes.toArray(new SOAPAttribute[newAttributes.size()]));
            this.updateUser(this.principal);
        }
    }

    private void updateUser(SOAPPrincipal user) throws PropertyException {
        try {
            this.userManager.updateUser(user);
        }
        catch (ApplicationPermissionException e) {
            throw new PropertyException("This application does not have the rights to update " + user.getName() + "'s details.");
        }
        catch (ObjectNotFoundException e) {
            throw new PropertyException("Could not find " + user.getName() + " to alter their details.");
        }
        catch (InvalidAuthorizationTokenException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public String getString(String property) throws PropertyException {
        String returnValue = null;
        if ("email".equals(property)) {
            String[] email = this.getPropertyValues("mail");
            return email.length > 0 ? email[0] : "";
        }
        if ("fullName".equals(property)) {
            String[] displayName = this.getPropertyValues("displayName");
            StringBuffer fullName = new StringBuffer();
            if (displayName.length > 0) {
                fullName.append(displayName[0]);
            } else {
                String[] fn = this.getPropertyValues("givenName");
                String[] ln = this.getPropertyValues("sn");
                if (fn.length > 0) {
                    fullName.append(fn[0]);
                }
                if (ln.length > 0) {
                    if (fullName.length() > 0) {
                        fullName.append(" ");
                    }
                    fullName.append(ln[0]);
                }
            }
            returnValue = fullName.toString();
        } else {
            String[] values = this.getPropertyValues(property);
            returnValue = values.length > 0 && values[0] != null ? values[0] : "";
        }
        return returnValue;
    }

    public boolean supportsType(int type) {
        return type == 5;
    }

    private String[] getPropertyValues(String key) {
        SOAPAttribute[] attributes = this.principal.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].getName().equals(key)) continue;
            return attributes[i].getValues();
        }
        return new String[0];
    }

    protected Collection splitFullnameIntoSOAPAttributes(String fullname) {
        ArrayList<SOAPAttribute> soapAttributes = new ArrayList<SOAPAttribute>();
        String[] strings = StringUtils.split((String)fullname, (String)" ", (int)2);
        if (strings.length > 1) {
            soapAttributes.add(new SOAPAttribute("givenName", strings[0]));
            soapAttributes.add(new SOAPAttribute("sn", strings[1]));
        } else if (strings.length > 0) {
            soapAttributes.add(new SOAPAttribute("givenName", strings[0]));
            soapAttributes.add(new SOAPAttribute("sn", " "));
        } else {
            soapAttributes.add(new SOAPAttribute("givenName", " "));
            soapAttributes.add(new SOAPAttribute("sn", " "));
        }
        soapAttributes.add(new SOAPAttribute("displayName", fullname));
        return soapAttributes;
    }

    public void setKeys(Map keys) {
        this.keys = keys;
    }

    public void setPrincipal(SOAPPrincipal principal) {
        this.principal = principal;
    }
}

