/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.service.cache;

import com.atlassian.crowd.integration.authentication.PrincipalAuthenticationContext;
import com.atlassian.crowd.integration.authentication.ValidationFactor;
import com.atlassian.crowd.integration.exception.InactiveAccountException;
import com.atlassian.crowd.integration.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.service.AuthenticationManager;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.util.Null;
import java.rmi.RemoteException;

public class AuthenticationManagerImpl
implements AuthenticationManager {
    SecurityServerClient ssc;

    public AuthenticationManagerImpl() {
    }

    public AuthenticationManagerImpl(SecurityServerClient ssc) {
        this.setSecurityServerClient(ssc);
    }

    public void setSecurityServerClient(SecurityServerClient ssc) {
        this.ssc = ssc;
    }

    private SecurityServerClient getServer() {
        return this.ssc;
    }

    public String authenticate(PrincipalAuthenticationContext authenticationContext) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, InactiveAccountException {
        Null.not(authenticationContext);
        if (authenticationContext.getApplication() == null) {
            authenticationContext.setApplication(this.getServer().getClientProperties().getApplicationName());
        }
        String token = this.getServer().authenticatePrincipal(authenticationContext);
        return token;
    }

    public String authenticate(String username, String password) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, InactiveAccountException {
        Null.not(username);
        Null.not(password);
        String token = this.getServer().authenticatePrincipalSimple(username, password);
        return token;
    }

    public boolean isAuthenticated(String token, ValidationFactor[] validationFactors) throws RemoteException, InvalidAuthorizationTokenException {
        Null.not(token);
        return this.getServer().isValidToken(token, validationFactors);
    }

    public void invalidate(String token) throws RemoteException, InvalidAuthorizationTokenException {
        Null.not(token);
        this.getServer().invalidateToken(token);
    }

    public SecurityServerClient getSecurityServerClient() {
        return this.getServer();
    }
}

