/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.service.soap.client;

import com.atlassian.crowd.integration.authentication.ApplicationAuthenticationContext;
import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.service.soap.client.ClientProperties;
import com.atlassian.crowd.integration.util.PropertyUtils;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ClientPropertiesImpl
implements ClientProperties {
    private static final Logger logger = Logger.getLogger(ClientProperties.class);
    private String applicationName = null;
    private String applicationPassword = null;
    private String applicationAuthenticationURL = null;
    private String securityServerURL = null;
    private String cookieTokenKey = null;
    private String sessionIsAuthenticated = null;
    private String sessionTokenKey = null;
    private String sessionLastValidation = null;
    private long sessionValidationInterval = 0L;
    private String httpProxyPort = null;
    private String httpProxyHost = null;
    private String httpProxyUsername = null;
    private String httpProxyPassword = null;
    private String httpMaxConnections = null;
    private String httpTimeout = null;
    private ApplicationAuthenticationContext applicationAuthenticationContext = null;
    private final PropertyUtils propertyUtils;

    public ClientPropertiesImpl(PropertyUtils propertyUtils) {
        this.propertyUtils = propertyUtils;
        Properties properties = propertyUtils.getProperties();
        this.updateProperties(properties);
    }

    public ClientPropertiesImpl() {
        this(new PropertyUtils());
    }

    public void updateProperties() {
        Properties properties = this.propertyUtils.getProperties();
        this.updateProperties(properties);
    }

    public void updateProperties(Properties properties) {
        this.applicationName = this.loadPropertyString(properties, "application.name", true);
        this.applicationPassword = this.loadPropertyString(properties, "application.password", false);
        this.applicationAuthenticationURL = this.loadPropertyString(properties, "application.login.url", true);
        this.securityServerURL = this.loadPropertyString(properties, "crowd.server.url", true);
        this.cookieTokenKey = this.loadPropertyString(properties, "cookie.tokenkey", false);
        if (this.cookieTokenKey == null) {
            this.cookieTokenKey = "crowd.token_key";
        }
        this.sessionIsAuthenticated = this.loadPropertyString(properties, "session.isauthenticated", true);
        this.sessionTokenKey = this.loadPropertyString(properties, "session.tokenkey", true);
        this.sessionLastValidation = this.loadPropertyString(properties, "session.lastvalidation", true);
        this.sessionValidationInterval = this.loadPropertyLong(properties, "session.validationinterval", true);
        this.httpProxyHost = this.loadPropertyString(properties, "http.proxy.host", false);
        this.httpProxyPort = this.loadPropertyString(properties, "http.proxy.port", false);
        this.httpProxyUsername = this.loadPropertyString(properties, "http.proxy.username", false);
        this.httpProxyPassword = this.loadPropertyString(properties, "http.proxy.password", false);
        this.httpMaxConnections = this.loadPropertyString(properties, "http.max.connections", false);
        this.httpTimeout = this.loadPropertyString(properties, "http.timeout", false);
        PasswordCredential credentials = new PasswordCredential(this.applicationPassword);
        this.applicationAuthenticationContext = new ApplicationAuthenticationContext();
        this.applicationAuthenticationContext.setName(this.applicationName);
        this.applicationAuthenticationContext.setCredential(credentials);
    }

    private long loadPropertyLong(Properties properties, String propertyName, boolean logProperty) {
        long propertyValue = 0L;
        String propertyValueAsString = this.loadPropertyString(properties, propertyName, logProperty);
        if (propertyValueAsString != null) {
            propertyValue = Long.parseLong(propertyValueAsString);
        }
        return propertyValue;
    }

    private String loadPropertyString(Properties properties, String propertyName, boolean logProperty) {
        String propertyValue = null;
        if (properties != null && properties.containsKey(propertyName)) {
            propertyValue = properties.getProperty(propertyName);
            if (logger.isDebugEnabled() && logProperty) {
                logger.debug((Object)("Loading property: '" + propertyName + "' : '" + propertyValue + "'"));
            }
        } else if (logProperty) {
            logger.info((Object)("Failed to find value for property: " + propertyName));
        }
        return propertyValue;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationPassword() {
        return this.applicationPassword;
    }

    public String getApplicationAuthenticationURL() {
        return this.applicationAuthenticationURL;
    }

    public String getSecurityServerURL() {
        return this.securityServerURL;
    }

    public String getCookieTokenKey() {
        return this.cookieTokenKey;
    }

    public void setCookieTokenKey(String cookieTokenKey) {
        this.cookieTokenKey = cookieTokenKey;
    }

    public String getSessionIsAuthenticated() {
        return this.sessionIsAuthenticated;
    }

    public String getSessionTokenKey() {
        return this.sessionTokenKey;
    }

    public String getSessionLastValidation() {
        return this.sessionLastValidation;
    }

    public long getSessionValidationInterval() {
        return this.sessionValidationInterval;
    }

    public ApplicationAuthenticationContext getApplicationAuthenticationContext() {
        return this.applicationAuthenticationContext;
    }

    public String getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public String getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public String getHttpMaxConnections() {
        return this.httpMaxConnections;
    }

    public String getHttpTimeout() {
        return this.httpTimeout;
    }
}

