/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.interceptors.WrapperHelper;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapperClassOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    public WrapperClassOutInterceptor() {
        super("pre-logical");
    }

    public void handleMessage(Message message) throws Fault {
        Exchange ex = message.getExchange();
        BindingOperationInfo bop = (BindingOperationInfo)ex.get(BindingOperationInfo.class);
        MessageInfo messageInfo = (MessageInfo)message.get(MessageInfo.class);
        if (messageInfo == null || bop == null || !bop.isUnwrapped()) {
            return;
        }
        BindingOperationInfo newbop = bop.getWrappedOperation();
        MessageInfo wrappedMsgInfo = Boolean.TRUE.equals(message.get((Object)"org.apache.cxf.client")) ? newbop.getInput().getMessageInfo() : newbop.getOutput().getMessageInfo();
        Class wrapped = null;
        List parts = wrappedMsgInfo.getMessageParts();
        if (parts.size() > 0) {
            wrapped = ((MessagePartInfo)parts.get(0)).getTypeClass();
        }
        if (wrapped != null) {
            MessageContentsList objs = MessageContentsList.getContentsList((Message)message);
            WrapperHelper helper = (WrapperHelper)((MessagePartInfo)parts.get(0)).getProperty("WRAPPER_CLASS", WrapperHelper.class);
            if (helper == null) {
                ArrayList<String> partNames = new ArrayList<String>();
                ArrayList<String> elTypeNames = new ArrayList<String>();
                ArrayList partClasses = new ArrayList();
                for (MessagePartInfo p : messageInfo.getMessageParts()) {
                    this.ensureSize(partNames, p.getIndex());
                    this.ensureSize(elTypeNames, p.getIndex());
                    this.ensureSize(partClasses, p.getIndex());
                    partNames.set(p.getIndex(), p.getName().getLocalPart());
                    Object elementType = null;
                    elementType = p.isElement() ? p.getElementQName().getLocalPart() : (p.getTypeQName() == null ? null : p.getTypeQName().getLocalPart());
                    elTypeNames.set(p.getIndex(), (String)elementType);
                    partClasses.set(p.getIndex(), p.getTypeClass());
                }
                helper = WrapperHelper.createWrapperHelper(wrapped, partNames, elTypeNames, partClasses);
                ((MessagePartInfo)parts.get(0)).setProperty("WRAPPER_CLASS", (Object)helper);
            }
            try {
                MessageContentsList newObjs = new MessageContentsList();
                Object o2 = helper.createWrapperObject((List<?>)objs);
                newObjs.put((MessagePartInfo)parts.get(0), o2);
                for (MessagePartInfo p : messageInfo.getMessageParts()) {
                    if (!Boolean.TRUE.equals(p.getProperty("messagepart.isheader"))) continue;
                    MessagePartInfo mpi = wrappedMsgInfo.getMessagePart(p.getName());
                    if (!objs.hasValue(p)) continue;
                    newObjs.put(mpi, objs.get(p));
                }
                message.setContent(List.class, (Object)newObjs);
            }
            catch (Exception e) {
                throw new Fault((Throwable)e);
            }
            ex.put(BindingOperationInfo.class, (Object)newbop);
            ex.put(OperationInfo.class, (Object)newbop.getOperationInfo());
            if (messageInfo == bop.getOperationInfo().getInput()) {
                message.put(MessageInfo.class, (Object)newbop.getOperationInfo().getInput());
                message.put(BindingMessageInfo.class, (Object)newbop.getInput());
            } else if (messageInfo == bop.getOperationInfo().getOutput()) {
                message.put(MessageInfo.class, (Object)newbop.getOperationInfo().getOutput());
                message.put(BindingMessageInfo.class, (Object)newbop.getOutput());
            }
        }
    }

    private void ensureSize(List<?> lst, int idx) {
        while (idx >= lst.size()) {
            lst.add(null);
        }
    }
}

