/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.api.container.grizzly;

import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.standalone.StaticStreamAlgorithm;
import com.sun.grizzly.tcp.Adapter;
import com.sun.ws.rest.api.container.ContainerFactory;
import java.io.IOException;
import java.net.URI;

public final class GrizzlyServerFactory {
    private GrizzlyServerFactory() {
    }

    public static SelectorThread create(String u) throws IOException {
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return GrizzlyServerFactory.create(URI.create(u));
    }

    public static SelectorThread create(URI u) throws IOException {
        return GrizzlyServerFactory.create(u, ContainerFactory.createContainer(Adapter.class));
    }

    public static SelectorThread create(String u, Adapter adapter) throws IOException {
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return GrizzlyServerFactory.create(URI.create(u));
    }

    public static SelectorThread create(URI u, Adapter adapter) throws IOException {
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        String scheme = u.getScheme();
        if (!scheme.equalsIgnoreCase("http")) {
            throw new IllegalArgumentException("The URI scheme, of the URI " + u + ", must be equal (ignoring case) to 'http'");
        }
        SelectorThread selectorThread = new SelectorThread();
        selectorThread.setAlgorithmClassName(StaticStreamAlgorithm.class.getName());
        int port = u.getPort() == -1 ? 80 : u.getPort();
        selectorThread.setPort(port);
        selectorThread.setAdapter(adapter);
        try {
            selectorThread.listen();
        }
        catch (InstantiationException e) {
            IOException _e = new IOException();
            _e.initCause(e);
            throw _e;
        }
        return selectorThread;
    }
}

