/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.application;

import com.sun.ws.rest.spi.service.ComponentProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentProviderCache {
    private static final Logger LOGGER = Logger.getLogger(ComponentProviderCache.class.getName());
    private final ComponentProvider componentProvider;
    private final Set<Class> providers;
    private final Map<Class, Object> cache;

    public ComponentProviderCache(ComponentProvider componentProvider, Set<Class> providers) {
        this.componentProvider = componentProvider;
        this.providers = providers;
        this.cache = new HashMap<Class, Object>();
    }

    public Set<Class> getProviderClasses(Class<?> service) {
        HashSet<Class> sp = new HashSet<Class>();
        for (Class p : this.providers) {
            if (!service.isAssignableFrom(p)) continue;
            sp.add(p);
        }
        return sp;
    }

    public Object getComponent(Class provider) {
        Object o = this.cache.get(provider);
        if (o != null) {
            return o;
        }
        try {
            o = this.componentProvider.getInstance(ComponentProvider.Scope.WebApplication, provider);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("The provider class, " + provider + ", could not be instantiated", ex);
        }
        this.cache.put(provider, o);
        return o;
    }
}

