/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.application;

import com.sun.ws.rest.impl.application.ComponentProviderCache;
import com.sun.ws.rest.spi.resource.Injectable;
import com.sun.ws.rest.spi.service.ContextResolver;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.core.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContextResolverFactory {
    private static final Logger LOGGER = Logger.getLogger(ContextResolverFactory.class.getName());
    private final Map<Type, Injectable<Context, ContextResolver>> injectables = new HashMap<Type, Injectable<Context, ContextResolver>>();

    public ContextResolverFactory(ComponentProviderCache componentProviderCache) {
        Set<Class> providerClasses = componentProviderCache.getProviderClasses(ContextResolver.class);
        HashMap typeMap = new HashMap();
        for (Class providerClass : providerClasses) {
            Set<ParameterizedType> types = this.getTypes(providerClass);
            ContextResolver provider = (ContextResolver)ContextResolver.class.cast(componentProviderCache.getComponent(providerClass));
            this.addTypes(typeMap, types, provider);
        }
        this.reduceToInjectables(typeMap);
    }

    public Map<Type, Injectable<Context, ContextResolver>> getInjectables() {
        return this.injectables;
    }

    private Set<ParameterizedType> getTypes(Class providerClass) {
        HashSet<ParameterizedType> types = new HashSet<ParameterizedType>();
        block0: while (providerClass != null) {
            for (Type type : providerClass.getGenericInterfaces()) {
                ParameterizedType pType;
                if (!(type instanceof ParameterizedType) || (pType = (ParameterizedType)type).getRawType() != ContextResolver.class) continue;
                types.add(pType);
                break block0;
            }
            providerClass = providerClass.getSuperclass();
        }
        return types;
    }

    private void addTypes(Map<ParameterizedType, List<ContextResolver<?>>> typeMap, Set<ParameterizedType> types, ContextResolver<?> provider) {
        for (ParameterizedType type : types) {
            List<ContextResolver<?>> l = typeMap.get(type);
            if (l == null) {
                l = new ArrayList();
                typeMap.put(type, l);
            }
            l.add(provider);
        }
    }

    private void reduceToInjectables(Map<ParameterizedType, List<ContextResolver<?>>> typeMap) {
        for (Map.Entry<ParameterizedType, List<ContextResolver<?>>> e : typeMap.entrySet()) {
            this.injectables.put(e.getKey(), new ContextResolverInjectable(this.reduce(e.getValue())));
        }
    }

    private ContextResolver reduce(List<ContextResolver<?>> crs) {
        if (crs.size() == 1) {
            return crs.get(0);
        }
        return new ContextResolverAdapter(crs);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ContextResolverAdapter
    implements ContextResolver {
        private final List<ContextResolver<?>> crs;

        ContextResolverAdapter(List<ContextResolver<?>> crs) {
            this.crs = crs;
        }

        public Object getContext(Class objectType) {
            for (ContextResolver<?> cr : this.crs) {
                Object c = cr.getContext(objectType);
                if (c == null) continue;
                return c;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ContextResolverInjectable
    extends Injectable<Context, ContextResolver> {
        private final ContextResolver cr;

        ContextResolverInjectable(ContextResolver cr) {
            this.cr = cr;
        }

        @Override
        public Class<Context> getAnnotationClass() {
            return Context.class;
        }

        @Override
        public ContextResolver getInjectableValue(Context a) {
            return this.cr;
        }
    }
}

