/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.application;

import com.sun.ws.rest.api.Responses;
import com.sun.ws.rest.api.container.ContainerException;
import com.sun.ws.rest.api.core.HttpContextAccess;
import com.sun.ws.rest.api.core.HttpResponseContext;
import com.sun.ws.rest.api.core.ResourceConfig;
import com.sun.ws.rest.api.model.AbstractResource;
import com.sun.ws.rest.api.model.ResourceModelIssue;
import com.sun.ws.rest.impl.ImplMessages;
import com.sun.ws.rest.impl.ThreadLocalHttpContext;
import com.sun.ws.rest.impl.application.ComponentProviderCache;
import com.sun.ws.rest.impl.application.ContextResolverFactory;
import com.sun.ws.rest.impl.application.MessageBodyFactory;
import com.sun.ws.rest.impl.application.WebApplicationContext;
import com.sun.ws.rest.impl.model.ResourceClass;
import com.sun.ws.rest.impl.model.RulesMap;
import com.sun.ws.rest.impl.modelapi.annotation.IntrospectionModeller;
import com.sun.ws.rest.impl.modelapi.validation.BasicValidator;
import com.sun.ws.rest.impl.uri.PathPattern;
import com.sun.ws.rest.impl.uri.PathTemplate;
import com.sun.ws.rest.impl.uri.UriHelper;
import com.sun.ws.rest.impl.uri.rules.ResourceClassRule;
import com.sun.ws.rest.impl.uri.rules.ResourceObjectRule;
import com.sun.ws.rest.impl.uri.rules.RightHandPathRule;
import com.sun.ws.rest.impl.uri.rules.RootResourceClassesRule;
import com.sun.ws.rest.impl.wadl.WadlFactory;
import com.sun.ws.rest.impl.wadl.WadlResource;
import com.sun.ws.rest.spi.container.ContainerRequest;
import com.sun.ws.rest.spi.container.ContainerResponse;
import com.sun.ws.rest.spi.container.MessageBodyContext;
import com.sun.ws.rest.spi.container.WebApplication;
import com.sun.ws.rest.spi.resource.Injectable;
import com.sun.ws.rest.spi.resource.ResourceProviderFactory;
import com.sun.ws.rest.spi.service.ComponentProvider;
import com.sun.ws.rest.spi.uri.rules.UriRule;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebApplicationImpl
implements WebApplication {
    private static final Logger LOGGER = Logger.getLogger(WebApplicationImpl.class.getName());
    private final ConcurrentMap<Class, ResourceClass> metaClassMap = new ConcurrentHashMap<Class, ResourceClass>();
    private final ResourceProviderFactory resolverFactory = ResourceProviderFactory.getInstance();
    private final ThreadLocalHttpContext context = new ThreadLocalHttpContext();
    private final HttpHeaders httpHeadersProxy;
    private final UriInfo uriInfoProxy;
    private final Request requestProxy;
    private final SecurityContext securityContextProxy;
    private final Map<Type, Injectable> injectables;
    private boolean initiated;
    private ResourceConfig resourceConfig;
    private RootResourceClassesRule rootsRule;
    private MessageBodyContext bodyContext;
    private ComponentProvider provider;

    public WebApplicationImpl() {
        InvocationHandler i = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.invoke((Object)WebApplicationImpl.this.context.getHttpRequestContext(), args);
            }
        };
        this.httpHeadersProxy = this.createProxy(HttpHeaders.class, i);
        this.uriInfoProxy = this.createProxy(UriInfo.class, i);
        this.requestProxy = this.createProxy(Request.class, i);
        this.securityContextProxy = this.createProxy(SecurityContext.class, i);
        this.injectables = this.createInjectables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceClass getResourceClass(Class c) {
        assert (c != null);
        ResourceClass rmc = (ResourceClass)this.metaClassMap.get(c);
        if (rmc != null) {
            return rmc;
        }
        ConcurrentMap<Class, ResourceClass> concurrentMap = this.metaClassMap;
        synchronized (concurrentMap) {
            rmc = (ResourceClass)this.metaClassMap.get(c);
            if (rmc != null) {
                return rmc;
            }
            rmc = this.newResourceClass(this.getAbstractResource(c));
            this.metaClassMap.put(c, rmc);
            return rmc;
        }
    }

    public ResourceClass getResourceClass(AbstractResource ar) {
        ResourceClass rc = this.newResourceClass(ar);
        this.metaClassMap.put(ar.getResourceClass(), rc);
        return rc;
    }

    private ResourceClass newResourceClass(AbstractResource ar) {
        assert (null != ar);
        BasicValidator validator = new BasicValidator();
        validator.validate(ar);
        boolean fatalIssueFound = false;
        for (ResourceModelIssue issue : validator.getIssueList()) {
            if (issue.isFatal()) {
                fatalIssueFound = true;
                if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                LOGGER.severe(issue.getMessage());
                continue;
            }
            if (!LOGGER.isLoggable(Level.WARNING)) continue;
            LOGGER.warning(issue.getMessage());
        }
        if (fatalIssueFound) {
            LOGGER.severe(ImplMessages.FATAL_ISSUES_FOUND_AT_RES_CLASS(ar.getResourceClass().getName()));
            throw new ContainerException(ImplMessages.FATAL_ISSUES_FOUND_AT_RES_CLASS(ar.getResourceClass().getName()));
        }
        return new ResourceClass(this.resourceConfig, this.getComponentProvider(), this.resolverFactory, ar);
    }

    private AbstractResource getAbstractResource(Class c) {
        return IntrospectionModeller.createResource(c);
    }

    private void injectResources(Object o) {
        this.injectResources(o.getClass(), o);
    }

    private void injectResources(Class oClass, Object o) {
        while (oClass != null) {
            for (Field f : oClass.getDeclaredFields()) {
                Injectable i = this.injectables.get(f.getGenericType());
                if (i == null) continue;
                i.inject(o, f);
            }
            oClass = oClass.getSuperclass();
        }
    }

    @Override
    public void initiate(ResourceConfig resourceConfig) {
        this.initiate(resourceConfig, null);
    }

    @Override
    public void initiate(ResourceConfig resourceConfig, ComponentProvider provider) {
        if (resourceConfig == null) {
            throw new IllegalArgumentException("ResourceConfig instance MUST NOT be null");
        }
        if (this.initiated) {
            throw new ContainerException(ImplMessages.WEB_APP_ALREADY_INITIATED());
        }
        this.initiated = true;
        this.resourceConfig = resourceConfig;
        this.verifyResourceConfig();
        this.addInjectable((Type)((Object)ResourceConfig.class), new HttpContextInjectable<ResourceConfig>(){

            @Override
            public ResourceConfig getInjectableValue(Context c) {
                return WebApplicationImpl.this.resourceConfig;
            }
        });
        this.provider = provider == null ? new DefaultComponentProvider() : new AdaptingComponentProvider(provider);
        ComponentProviderCache cpc = new ComponentProviderCache(this.provider, resourceConfig.getProviderClasses());
        ContextResolverFactory crf = new ContextResolverFactory(cpc);
        this.injectables.putAll(crf.getInjectables());
        this.bodyContext = new MessageBodyFactory(cpc);
        this.rootsRule = new RootResourceClassesRule(this.processRootResources(resourceConfig.getResourceClasses()));
    }

    @Override
    public MessageBodyContext getMessageBodyContext() {
        return this.bodyContext;
    }

    @Override
    public ComponentProvider getComponentProvider() {
        return this.provider;
    }

    @Override
    public void handleRequest(ContainerRequest request, ContainerResponse response) {
        URI normalizedUri;
        URI uri;
        WebApplicationContext localContext = new WebApplicationContext(this, request, response);
        this.context.set(localContext);
        if (this.resourceConfig.getFeature("com.sun.ws.rest.config.feature.NormalizeURI") && (uri = request.getRequestUri()) != (normalizedUri = UriHelper.normalize(uri, !this.resourceConfig.getFeature("com.sun.ws.rest.config.feature.CanonicalizeURIPath"))) && this.resourceConfig.getFeature("com.sun.ws.rest.config.feature.Redirect")) {
            response.setResponse(Response.temporaryRedirect((URI)normalizedUri).build());
            return;
        }
        StringBuilder path = new StringBuilder();
        path.append("/").append(request.getPath(false));
        if (!this.resourceConfig.getFeature("com.sun.ws.rest.config.feature.IgnoreMatrixParams")) {
            path = this.stripMatrixParams(path);
        }
        try {
            if (!this.rootsRule.accept(path, null, localContext)) {
                response.setResponse(Responses.notFound().build());
            }
        }
        catch (WebApplicationException e) {
            WebApplicationImpl.onExceptionWithWebApplication(e, response);
        }
    }

    @Override
    public void addInjectable(Type fieldType, Injectable injectable) {
        this.injectables.put(fieldType, injectable);
    }

    private void verifyResourceConfig() {
        Iterator<Class> i = this.resourceConfig.getProviderClasses().iterator();
        while (i.hasNext()) {
            Class pc = i.next();
            if (pc.isAnnotationPresent(Provider.class)) continue;
            LOGGER.warning("The class, " + pc + ", registered as a provider class " + "of the ResourceConfig is not annotationed with " + Provider.class + ". This class will be ignored");
            i.remove();
        }
    }

    private RulesMap<UriRule> processRootResources(Set<Class> classes) {
        if (classes.isEmpty()) {
            LOGGER.severe(ImplMessages.NO_ROOT_RES_IN_RES_CFG());
            throw new ContainerException(ImplMessages.NO_ROOT_RES_IN_RES_CFG());
        }
        RulesMap<UriRule> rulesMap = new RulesMap<UriRule>();
        HashSet<AbstractResource> rootResources = new HashSet<AbstractResource>();
        for (Class c : classes) {
            AbstractResource ar = this.getAbstractResource(c);
            if (!ar.isRootResource()) {
                LOGGER.warning("The class, " + c + ", registered as a root resource class " + "of the ResourceConfig is not a root resource class" + ". This class will be ignored");
                continue;
            }
            int modifiers = c.getModifiers();
            if (Modifier.isAbstract(modifiers) && !Modifier.isInterface(modifiers)) {
                LOGGER.warning("The " + c + ", registered as a root resource class " + "of the ResourceConfig cannot be instantiated" + ". This class will be ignored");
                continue;
            }
            if (Modifier.isInterface(modifiers)) {
                LOGGER.warning("The " + c + ", registered as a root resource class " + "of the ResourceConfig cannot be instantiated" + ". This interface will be ignored");
                continue;
            }
            ResourceClass r = this.getResourceClass(ar);
            rootResources.add(r.resource);
            PathTemplate t = new PathTemplate(r.resource.getUriPath().getValue(), r.resource.getUriPath().isEncode());
            PathPattern p = new PathPattern(t, r.hasSubResources);
            rulesMap.put(p, new RightHandPathRule(this.resourceConfig.getFeature("com.sun.ws.rest.config.feature.Redirect"), t.endsWithSlash(), new ResourceClassRule(t.getTemplateVariables(), c)));
        }
        this.createWadlResource(rootResources, rulesMap);
        return rulesMap;
    }

    private void createWadlResource(Set<AbstractResource> rootResources, RulesMap<UriRule> rulesMap) {
        Object wr = WadlFactory.createWadlResource(rootResources);
        if (wr == null) {
            return;
        }
        ResourceClass r = this.getResourceClass(WadlResource.class);
        PathTemplate t = new PathTemplate("application.wadl", false);
        PathPattern p = new PathPattern(t, r.hasSubResources);
        rulesMap.put(p, new RightHandPathRule(this.resourceConfig.getFeature("com.sun.ws.rest.config.feature.Redirect"), false, new ResourceObjectRule(t.getTemplateVariables(), wr)));
    }

    private StringBuilder stripMatrixParams(StringBuilder path) {
        int e = path.indexOf(";");
        if (e == -1) {
            return path;
        }
        int s = 0;
        StringBuilder sb = new StringBuilder();
        do {
            sb.append(path, s, e);
        } while ((s = path.indexOf("/", e + 1)) != -1 && (e = path.indexOf(";", s)) != -1);
        if (s != -1) {
            sb.append(path, s, path.length());
        }
        return sb;
    }

    private <T> T createProxy(Class<T> c, InvocationHandler i) {
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{c}, i);
    }

    private Map<Type, Injectable> createInjectables() {
        HashMap<Type, Injectable> is = new HashMap<Type, Injectable>();
        is.put((Type)((Object)MessageBodyContext.class), new HttpContextInjectable<MessageBodyContext>(){

            @Override
            public MessageBodyContext getInjectableValue(Context c) {
                return WebApplicationImpl.this.bodyContext;
            }
        });
        is.put((Type)((Object)HttpContextAccess.class), new HttpContextInjectable<HttpContextAccess>(){

            @Override
            public HttpContextAccess getInjectableValue(Context c) {
                return WebApplicationImpl.this.context;
            }
        });
        is.put((Type)((Object)HttpHeaders.class), new HttpContextInjectable<HttpHeaders>(){

            @Override
            public HttpHeaders getInjectableValue(Context c) {
                return WebApplicationImpl.this.httpHeadersProxy;
            }
        });
        is.put((Type)((Object)UriInfo.class), new HttpContextInjectable<UriInfo>(){

            @Override
            public UriInfo getInjectableValue(Context c) {
                return WebApplicationImpl.this.uriInfoProxy;
            }
        });
        is.put((Type)((Object)Request.class), new HttpContextInjectable<Request>(){

            @Override
            public Request getInjectableValue(Context c) {
                return WebApplicationImpl.this.requestProxy;
            }
        });
        is.put((Type)((Object)SecurityContext.class), new HttpContextInjectable<SecurityContext>(){

            @Override
            public SecurityContext getInjectableValue(Context c) {
                return WebApplicationImpl.this.securityContextProxy;
            }
        });
        return is;
    }

    private static void onExceptionWithWebApplication(WebApplicationException e, HttpResponseContext response) {
        Response r = e.getResponse();
        if (r.getStatus() >= 500) {
            e.printStackTrace();
        }
        if (r.getStatus() >= 500 && r.getEntity() == null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.flush();
            r = Response.status((int)r.getStatus()).entity((Object)sw.toString()).type("text/plain").build();
        }
        response.setResponse(r);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class HttpContextInjectable<V>
    extends Injectable<Context, V> {
        private HttpContextInjectable() {
        }

        @Override
        public Class<Context> getAnnotationClass() {
            return Context.class;
        }
    }

    private final class DefaultComponentProvider
    implements ComponentProvider {
        private DefaultComponentProvider() {
        }

        public Object getInstance(ComponentProvider.Scope scope, Class c) throws InstantiationException, IllegalAccessException {
            Object o = c.newInstance();
            WebApplicationImpl.this.injectResources(o);
            return o;
        }

        public Object getInstance(ComponentProvider.Scope scope, Constructor contructor, Object[] parameters) throws InstantiationException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            Object o = contructor.newInstance(parameters);
            WebApplicationImpl.this.injectResources(o);
            return o;
        }

        public void inject(Object instance) {
            WebApplicationImpl.this.injectResources(instance);
        }
    }

    private final class AdaptingComponentProvider
    implements ComponentProvider {
        private final ComponentProvider cp;

        AdaptingComponentProvider(ComponentProvider cp) {
            this.cp = cp;
        }

        public Object getInstance(ComponentProvider.Scope scope, Class c) throws InstantiationException, IllegalAccessException {
            Object o = this.cp.getInstance(scope, c);
            if (o == null) {
                o = c.newInstance();
            }
            WebApplicationImpl.this.injectResources(o);
            return o;
        }

        public Object getInstance(ComponentProvider.Scope scope, Constructor contructor, Object[] parameters) throws InstantiationException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            Object o = this.cp.getInstance(scope, contructor, parameters);
            if (o == null) {
                o = contructor.newInstance(parameters);
            }
            WebApplicationImpl.this.injectResources(o);
            return o;
        }

        public void inject(Object instance) {
            this.cp.inject(instance);
            WebApplicationImpl.this.injectResources(instance);
        }
    }
}

