/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.client.urlconnection;

import com.sun.ws.rest.api.client.ClientHandler;
import com.sun.ws.rest.api.client.ClientHandlerException;
import com.sun.ws.rest.api.client.ClientRequest;
import com.sun.ws.rest.api.client.ClientResponse;
import com.sun.ws.rest.impl.RequestHttpHeadersImpl;
import com.sun.ws.rest.spi.container.MessageBodyContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class URLConnectionClientHandler
implements ClientHandler {
    @Context
    private MessageBodyContext bodyContext;

    @Override
    public ClientResponse handle(ClientRequest ro) {
        try {
            return this._invoke(ro);
        }
        catch (Exception ex) {
            throw new ClientHandlerException(ex);
        }
    }

    private ClientResponse _invoke(ClientRequest ro) throws ProtocolException, IOException {
        HttpURLConnection uc = (HttpURLConnection)ro.getURI().toURL().openConnection();
        uc.setRequestMethod(ro.getMethod());
        this.writeHeaders(ro.getMetadata(), uc);
        Object entity = ro.getEntity();
        if (entity != null) {
            uc.setDoOutput(true);
            this.writeEntity(uc, ro.getMetadata(), entity);
        }
        return new URLConnectionResponse(uc.getResponseCode(), uc);
    }

    private void writeHeaders(MultivaluedMap<String, Object> metadata, HttpURLConnection uc) {
        for (Map.Entry e : metadata.entrySet()) {
            List vs = (List)e.getValue();
            if (vs.size() == 1) {
                uc.setRequestProperty((String)e.getKey(), this.getHeaderValue(vs.get(0)));
                continue;
            }
            StringBuilder b = new StringBuilder();
            boolean add = false;
            for (Object v : (List)e.getValue()) {
                if (add) {
                    b.append(',');
                }
                add = true;
                b.append(this.getHeaderValue(v));
            }
            uc.setRequestProperty((String)e.getKey(), b.toString());
        }
    }

    private String getHeaderValue(Object headerValue) {
        RuntimeDelegate.HeaderDelegate hp = RuntimeDelegate.getInstance().createHeaderDelegate(headerValue.getClass());
        return hp.toString(headerValue);
    }

    private void writeEntity(HttpURLConnection uc, MultivaluedMap<String, Object> metadata, Object entity) throws IOException {
        MediaType mediaType = null;
        Object mediaTypeHeader = metadata.getFirst((Object)"Content-Type");
        mediaType = mediaTypeHeader instanceof MediaType ? (MediaType)mediaTypeHeader : (mediaTypeHeader != null ? MediaType.parse((String)mediaTypeHeader.toString()) : new MediaType("application", "octet-stream"));
        MessageBodyWriter<?> p = this.bodyContext.getMessageBodyWriter(entity.getClass(), mediaType);
        long size = p.getSize(entity);
        if (size != -1L && size < Integer.MAX_VALUE) {
            uc.setFixedLengthStreamingMode((int)size);
        }
        OutputStream out = uc.getOutputStream();
        p.writeTo(entity, mediaType, metadata, out);
        out.flush();
        out.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class URLConnectionResponse
    extends ClientResponse {
        private final int status;
        private final HttpURLConnection uc;
        private final MultivaluedMap<String, String> metadata;
        private Map<String, Object> properties;

        URLConnectionResponse(int status, HttpURLConnection uc) {
            this.status = status;
            this.uc = uc;
            this.metadata = new RequestHttpHeadersImpl();
            for (Map.Entry<String, List<String>> e : uc.getHeaderFields().entrySet()) {
                if (e.getKey() == null) continue;
                this.metadata.put((Object)e.getKey(), e.getValue());
            }
        }

        @Override
        public int getStatus() {
            return this.status;
        }

        @Override
        public MultivaluedMap<String, String> getMetadata() {
            return this.metadata;
        }

        @Override
        public boolean hasEntity() {
            int l = this.uc.getContentLength();
            return l > 0 || l == -1;
        }

        @Override
        public <T> T getEntity(Class<T> c) {
            try {
                MediaType mediaType = this.getType();
                return (T)URLConnectionClientHandler.this.bodyContext.getMessageBodyReader(c, mediaType).readFrom(c, mediaType, this.metadata, this.getInputStream());
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        @Override
        public Map<String, Object> getProperties() {
            if (this.properties != null) {
                return this.properties;
            }
            this.properties = new HashMap<String, Object>();
            return this.properties;
        }

        private InputStream getInputStream() throws IOException {
            if (this.status < 300) {
                return this.uc.getInputStream();
            }
            return this.uc.getErrorStream();
        }
    }
}

