/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.container.httpserver;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.ws.rest.api.container.ContainerException;
import com.sun.ws.rest.api.core.HttpResponseContext;
import com.sun.ws.rest.impl.container.httpserver.HttpServerRequestAdaptor;
import com.sun.ws.rest.impl.container.httpserver.HttpServerResponseAdaptor;
import com.sun.ws.rest.spi.container.WebApplication;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.ws.rs.core.Response;

public class HttpHandlerContainer
implements HttpHandler {
    private WebApplication application;

    public HttpHandlerContainer(WebApplication app) throws ContainerException {
        this.application = app;
    }

    public void handle(HttpExchange httpExchange) throws IOException {
        HttpServerRequestAdaptor requestAdaptor = new HttpServerRequestAdaptor(this.application.getMessageBodyContext(), httpExchange);
        HttpServerResponseAdaptor responseAdaptor = new HttpServerResponseAdaptor(httpExchange, this.application.getMessageBodyContext(), requestAdaptor);
        try {
            this.application.handleRequest(requestAdaptor, responseAdaptor);
        }
        catch (ContainerException e) {
            HttpHandlerContainer.onException(e, responseAdaptor);
        }
        catch (RuntimeException e) {
            HttpHandlerContainer.onException(e, responseAdaptor);
        }
        try {
            responseAdaptor.commitAll();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private static void onException(Exception e, HttpResponseContext response) {
        e.printStackTrace();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.flush();
        response.setResponse(Response.serverError().entity((Object)sw.toString()).type("text/plain").build());
    }
}

