/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.container.httpserver;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.ws.rest.impl.container.httpserver.HttpServerRequestAdaptor;
import com.sun.ws.rest.spi.container.AbstractContainerResponse;
import com.sun.ws.rest.spi.container.MessageBodyContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class HttpServerResponseAdaptor
extends AbstractContainerResponse {
    private final HttpExchange exchange;

    HttpServerResponseAdaptor(HttpExchange exchange, MessageBodyContext bodyContext, HttpServerRequestAdaptor requestContext) {
        super(bodyContext, requestContext);
        this.exchange = exchange;
    }

    protected OutputStream getUnderlyingOutputStream() throws IOException {
        return this.exchange.getResponseBody();
    }

    protected void commitStatusAndHeaders() throws IOException {
        this.commitHeaders();
        this.exchange.sendResponseHeaders(this.getStatus(), 0L);
    }

    private void commitHeaders() throws IOException {
        Headers eh = this.exchange.getResponseHeaders();
        for (Map.Entry e : this.getHttpHeaders().entrySet()) {
            ArrayList<String> values = new ArrayList<String>();
            for (Object v : (List)e.getValue()) {
                values.add(this.getHeaderValue(v));
            }
            eh.put((String)e.getKey(), (List<String>)values);
        }
    }

    void commitAll() throws IOException {
        if (this.isCommitted()) {
            this.exchange.getResponseBody().flush();
            this.exchange.getResponseBody().close();
            this.exchange.close();
            return;
        }
        this.commitHeaders();
        Object entity = this.getEntity();
        if (entity != null) {
            this.exchange.sendResponseHeaders(this.getStatus(), 0L);
            this.writeEntity(entity, this.getUnderlyingOutputStream());
        } else {
            this.exchange.sendResponseHeaders(this.getStatus(), -1L);
        }
        this.exchange.getResponseBody().flush();
        this.exchange.getResponseBody().close();
        this.exchange.close();
    }
}

