/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.container.servlet;

import com.sun.ws.rest.api.container.ContainerException;
import com.sun.ws.rest.api.uri.UriComponent;
import com.sun.ws.rest.spi.container.AbstractContainerRequest;
import com.sun.ws.rest.spi.container.MessageBodyContext;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;

public final class HttpRequestAdaptor
extends AbstractContainerRequest {
    private final HttpServletRequest request;

    public HttpRequestAdaptor(MessageBodyContext bodyContext, HttpServletRequest request) throws IOException {
        super(bodyContext, request.getMethod(), (InputStream)request.getInputStream());
        this.request = request;
        this.initiateUriInfo();
        this.copyHttpHeaders();
    }

    private void initiateUriInfo() {
        String encodedBasePath;
        UriBuilder absoluteUriBuilder = UriBuilder.fromUri((String)this.request.getRequestURL().toString());
        String decodedBasePath = this.request.getPathInfo() != null ? this.request.getContextPath() + this.request.getServletPath() + "/" : this.request.getContextPath() + "/";
        if (!decodedBasePath.equals(encodedBasePath = UriComponent.encode(decodedBasePath, UriComponent.Type.PATH))) {
            throw new ContainerException("The servlet context path and/or the servlet path contain characters that are percent enocded");
        }
        String queryParameters = this.request.getQueryString();
        if (queryParameters == null) {
            queryParameters = "";
        }
        this.baseUri = absoluteUriBuilder.encode(false).replacePath(new String[]{encodedBasePath}).build();
        this.completeUri = absoluteUriBuilder.encode(false).replacePath(new String[]{this.request.getRequestURI()}).replaceQueryParams(queryParameters).build();
    }

    private void copyHttpHeaders() {
        MultivaluedMap<String, String> headers = this.getRequestHeaders();
        Enumeration names = this.request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            LinkedList valueList = new LinkedList();
            Enumeration values = this.request.getHeaders(name);
            while (values.hasMoreElements()) {
                valueList.add(values.nextElement());
            }
            headers.put((Object)name, valueList);
        }
        Map<String, Cookie> cookies = this.getCookies();
        javax.servlet.http.Cookie[] servletCookies = this.request.getCookies();
        if (servletCookies != null) {
            for (javax.servlet.http.Cookie c : servletCookies) {
                Cookie _c = new Cookie(c.getName(), c.getValue(), c.getPath(), c.getDomain(), c.getVersion());
                cookies.put(c.getName(), _c);
            }
        }
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public String getAuthenticationScheme() {
        return this.request.getAuthType();
    }
}

