/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.model.method.dispatch;

import com.sun.ws.rest.api.container.ContainerException;
import com.sun.ws.rest.api.core.HttpRequestContext;
import com.sun.ws.rest.api.core.HttpResponseContext;
import com.sun.ws.rest.api.model.AbstractResourceMethod;
import com.sun.ws.rest.api.model.Parameter;
import com.sun.ws.rest.impl.ResponseBuilderImpl;
import com.sun.ws.rest.impl.model.ReflectionHelper;
import com.sun.ws.rest.impl.model.method.dispatch.ResourceJavaMethodDispatcher;
import com.sun.ws.rest.impl.model.method.dispatch.ResourceMethodDispatchProvider;
import com.sun.ws.rest.impl.model.parameter.ParameterExtractor;
import com.sun.ws.rest.impl.model.parameter.ParameterProcessor;
import com.sun.ws.rest.impl.model.parameter.ParameterProcessorFactory;
import com.sun.ws.rest.spi.dispatch.RequestDispatcher;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.TypeVariable;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class EntityParamDispatchProvider
implements ResourceMethodDispatchProvider {
    public RequestDispatcher create(AbstractResourceMethod abstractResourceMethod) {
        ParameterExtractor[] extractors;
        boolean requireReturnOfRepresentation = false;
        boolean requireNoEntityParameter = false;
        if ("GET".equals(abstractResourceMethod.getHttpMethod())) {
            requireReturnOfRepresentation = true;
            requireNoEntityParameter = true;
        }
        if ((extractors = this.processParameters(abstractResourceMethod, requireNoEntityParameter)) == null) {
            return null;
        }
        Class<?> returnType = abstractResourceMethod.getMethod().getReturnType();
        if (Response.class.isAssignableFrom(returnType)) {
            return new ResponseOutInvoker(abstractResourceMethod, extractors);
        }
        if (returnType != Void.TYPE) {
            if (returnType == Object.class) {
                return new ObjectOutInvoker(abstractResourceMethod, extractors);
            }
            return new TypeOutInvoker(abstractResourceMethod, extractors);
        }
        if (requireReturnOfRepresentation) {
            return null;
        }
        return new VoidOutInvoker(abstractResourceMethod, extractors);
    }

    private ParameterExtractor[] processParameters(AbstractResourceMethod method, boolean requireNoEntityParameter) {
        if (null == method.getParameters() || 0 == method.getParameters().size()) {
            return new ParameterExtractor[0];
        }
        ParameterExtractor[] extractors = new ParameterExtractor[method.getParameters().size()];
        for (int i = 0; i < method.getParameters().size(); ++i) {
            extractors[i] = this.processParameter(method, method.getParameters().get(i), requireNoEntityParameter);
            if (extractors[i] != null) continue;
            return null;
        }
        return extractors;
    }

    private ParameterExtractor processParameter(AbstractResourceMethod method, Parameter parameter, boolean requireNoEntityParameter) {
        if (Parameter.Source.ENTITY == parameter.getSource()) {
            if (requireNoEntityParameter) {
                return null;
            }
            if (parameter.getParameterType() instanceof TypeVariable) {
                Class c = ReflectionHelper.resolveTypeVariable(method.getDeclaringResource().getResourceClass(), method.getMethod().getDeclaringClass(), (TypeVariable)parameter.getParameterType());
                return c != null ? new EntityExtractor(c) : null;
            }
            return new EntityExtractor(parameter.getParameterClass());
        }
        ParameterProcessor p = ParameterProcessorFactory.createParameterProcessor(parameter.getSource());
        if (null == p) {
            return null;
        }
        return p.process(parameter);
    }

    static final class ObjectOutInvoker
    extends EntityParamInInvoker {
        ObjectOutInvoker(AbstractResourceMethod abstractResourceMethod, ParameterExtractor[] injectors) {
            super(abstractResourceMethod, injectors);
        }

        public void _dispatch(Object resource, HttpRequestContext requestContext, HttpResponseContext responseContext) throws IllegalAccessException, InvocationTargetException {
            Object[] params = this.getParams(requestContext);
            Object o = this.method.invoke(resource, params);
            MediaType mediaType = this.getAcceptableMediaType(requestContext);
            if (o instanceof Response) {
                Response r = (Response)o;
                responseContext.setResponse(r, mediaType);
            } else {
                Response r = new ResponseBuilderImpl().status(200).entity(o).type(mediaType).build();
                responseContext.setResponse(r);
            }
        }
    }

    static final class ResponseOutInvoker
    extends EntityParamInInvoker {
        ResponseOutInvoker(AbstractResourceMethod abstractResourceMethod, ParameterExtractor[] injectors) {
            super(abstractResourceMethod, injectors);
        }

        public void _dispatch(Object resource, HttpRequestContext requestContext, HttpResponseContext responseContext) throws IllegalAccessException, InvocationTargetException {
            Object[] params = this.getParams(requestContext);
            Response r = (Response)this.method.invoke(resource, params);
            MediaType mediaType = this.getAcceptableMediaType(requestContext);
            responseContext.setResponse(r, mediaType);
        }
    }

    static final class TypeOutInvoker
    extends EntityParamInInvoker {
        TypeOutInvoker(AbstractResourceMethod abstractResourceMethod, ParameterExtractor[] injectors) {
            super(abstractResourceMethod, injectors);
        }

        public void _dispatch(Object resource, HttpRequestContext requestContext, HttpResponseContext responseContext) throws IllegalAccessException, InvocationTargetException {
            Object[] params = this.getParams(requestContext);
            Object o = this.method.invoke(resource, params);
            MediaType mediaType = this.getAcceptableMediaType(requestContext);
            Response r = new ResponseBuilderImpl().status(200).entity(o).type(mediaType).build();
            responseContext.setResponse(r);
        }
    }

    static final class VoidOutInvoker
    extends EntityParamInInvoker {
        VoidOutInvoker(AbstractResourceMethod abstractResourceMethod, ParameterExtractor[] injectors) {
            super(abstractResourceMethod, injectors);
        }

        public void _dispatch(Object resource, HttpRequestContext requestContext, HttpResponseContext responseContext) throws IllegalAccessException, InvocationTargetException {
            Object[] params = this.getParams(requestContext);
            this.method.invoke(resource, params);
        }
    }

    static abstract class EntityParamInInvoker
    extends ResourceJavaMethodDispatcher {
        private final ParameterExtractor[] injectors;

        EntityParamInInvoker(AbstractResourceMethod abstractResourceMethod, ParameterExtractor[] injectors) {
            super(abstractResourceMethod);
            this.injectors = injectors;
        }

        protected final Object[] getParams(HttpRequestContext request) {
            Object[] params = new Object[this.injectors.length];
            try {
                for (int i = 0; i < this.injectors.length; ++i) {
                    params[i] = this.injectors[i].extract(request);
                }
                return params;
            }
            catch (WebApplicationException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ContainerException("Exception injecting parameters to Web resource method", e);
            }
        }
    }

    static final class EntityExtractor
    implements ParameterExtractor {
        final Class parameterEntityType;

        EntityExtractor(Class parameterEntityType) {
            this.parameterEntityType = parameterEntityType;
        }

        public Object extract(HttpRequestContext request) {
            return request.getEntity(this.parameterEntityType);
        }
    }
}

