/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.model.parameter;

import com.sun.ws.rest.api.core.HttpRequestContext;
import com.sun.ws.rest.api.model.Parameter;
import com.sun.ws.rest.impl.model.parameter.MultivaluedDefaultListParameterProcessor;
import com.sun.ws.rest.impl.model.parameter.MultivaluedParameterExtractor;
import com.sun.ws.rest.impl.model.parameter.ParameterExtractor;
import com.sun.ws.rest.impl.model.parameter.ParameterProcessor;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;

public final class MatrixParameterProcessor
implements ParameterProcessor {
    public ParameterExtractor process(Parameter parameter) {
        String parameterName = parameter.getSourceName();
        if (parameterName == null || parameterName.length() == 0) {
            return null;
        }
        MultivaluedParameterExtractor e = MultivaluedDefaultListParameterProcessor.process(parameter.getDefaultValue(), parameter.getParameterClass(), parameter.getParameterType(), parameterName);
        if (e == null) {
            return null;
        }
        return new MatrixParameterExtractor(e, !parameter.isEncoded());
    }

    private static final class MatrixParameterExtractor
    implements ParameterExtractor {
        private final MultivaluedParameterExtractor extractor;
        private final boolean decode;

        MatrixParameterExtractor(MultivaluedParameterExtractor extractor) {
            this(extractor, true);
        }

        MatrixParameterExtractor(MultivaluedParameterExtractor extractor, boolean decode) {
            this.extractor = extractor;
            this.decode = decode;
        }

        public Object extract(HttpRequestContext request) {
            List l = request.getPathSegments(this.decode);
            PathSegment p = (PathSegment)l.get(l.size() - 1);
            return this.extractor.extract((MultivaluedMap<String, String>)p.getMatrixParameters());
        }
    }
}

