/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.model.parameter;

import com.sun.ws.rest.api.container.ContainerException;
import com.sun.ws.rest.api.model.AbstractResourceConstructor;
import com.sun.ws.rest.api.model.AbstractSubResourceLocator;
import com.sun.ws.rest.api.model.Parameter;
import com.sun.ws.rest.impl.ImplMessages;
import com.sun.ws.rest.impl.model.parameter.ParameterExtractor;
import com.sun.ws.rest.impl.model.parameter.ParameterProcessor;
import com.sun.ws.rest.impl.model.parameter.ParameterProcessorFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParameterExtractorFactory {
    private ParameterExtractorFactory() {
    }

    public static ParameterExtractor[] createExtractorsForSublocator(AbstractSubResourceLocator subResLocator) {
        ParameterExtractor[] extractors;
        for (ParameterExtractor extractor : extractors = ParameterExtractorFactory.processParameters(subResLocator)) {
            if (extractor != null) continue;
            String msg = ImplMessages.NOT_VALID_DYNAMICRESOLVINGMETHOD(subResLocator.getMethod(), "", subResLocator.getMethod().getDeclaringClass());
            throw new ContainerException(msg);
        }
        return extractors;
    }

    public static ParameterExtractor[] createExtractorsForConstructor(AbstractResourceConstructor aRCtor) {
        return ParameterExtractorFactory.processParameters(aRCtor.getParameters());
    }

    private static ParameterExtractor[] processParameters(AbstractSubResourceLocator subResLocator) {
        return ParameterExtractorFactory.processParameters(subResLocator.getParameters());
    }

    private static ParameterExtractor[] processParameters(List<Parameter> parameters) {
        ParameterExtractor[] extractors = new ParameterExtractor[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            extractors[i] = ParameterExtractorFactory.processParameter(parameters.get(i));
        }
        return extractors;
    }

    private static ParameterExtractor processParameter(Parameter parameter) {
        ParameterProcessor p = ParameterProcessorFactory.createParameterProcessor(parameter.getSource());
        if (null == p) {
            return null;
        }
        return p.process(parameter);
    }
}

