/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.modelapi.annotation;

import com.sun.ws.rest.api.model.AbstractResource;
import com.sun.ws.rest.api.model.AbstractResourceConstructor;
import com.sun.ws.rest.api.model.AbstractResourceMethod;
import com.sun.ws.rest.api.model.AbstractSubResourceLocator;
import com.sun.ws.rest.api.model.AbstractSubResourceMethod;
import com.sun.ws.rest.api.model.Parameter;
import com.sun.ws.rest.api.model.Parameterized;
import com.sun.ws.rest.api.model.UriPathValue;
import com.sun.ws.rest.impl.ImplMessages;
import com.sun.ws.rest.impl.model.MediaTypeHelper;
import com.sun.ws.rest.impl.modelapi.annotation.MethodList;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ConsumeMime;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.ProduceMime;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntrospectionModeller {
    private static final Logger LOGGER = Logger.getLogger(IntrospectionModeller.class.getName());
    private static final Map<Class, ParamAnnotationHelper> ANOT_HELPER_MAP = IntrospectionModeller.createParamAnotHelperMap();

    public static final AbstractResource createResource(Class<?> resourceClass) {
        Path rPathAnnotation = resourceClass.getAnnotation(Path.class);
        boolean isRootResourceClass = null != rPathAnnotation;
        boolean isEncodedAnotOnClass = null != resourceClass.getAnnotation(Encoded.class);
        AbstractResource resource = isRootResourceClass ? new AbstractResource(resourceClass, new UriPathValue(rPathAnnotation.value(), rPathAnnotation.encode(), rPathAnnotation.limited())) : new AbstractResource(resourceClass);
        IntrospectionModeller.workOutConstructorsList(resource, resourceClass.getConstructors(), isEncodedAnotOnClass);
        MethodList methodList = new MethodList(resourceClass);
        ConsumeMime classScopeConsumeMimeAnnotation = resourceClass.getAnnotation(ConsumeMime.class);
        ProduceMime classScopeProduceMimeAnnotation = resourceClass.getAnnotation(ProduceMime.class);
        IntrospectionModeller.workOutResourceMethodsList(resource, methodList, isEncodedAnotOnClass, classScopeConsumeMimeAnnotation, classScopeProduceMimeAnnotation);
        IntrospectionModeller.workOutSubResourceMethodsList(resource, methodList, isEncodedAnotOnClass, classScopeConsumeMimeAnnotation, classScopeProduceMimeAnnotation);
        IntrospectionModeller.workOutSubResourceLocatorsList(resource, methodList, isEncodedAnotOnClass);
        IntrospectionModeller.logNonPublicMethods(resourceClass);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(ImplMessages.NEW_AR_CREATED_BY_INTROSPECTION_MODELER(resource.toString()));
        }
        return resource;
    }

    private static final void findOutConsumeMimeTypes(AbstractResourceMethod resourceMethod, ConsumeMime classScopeConsumeMimeAnnotation) {
        if (resourceMethod.getMethod().isAnnotationPresent(ConsumeMime.class)) {
            ConsumeMime consumeMimeAnnotation = resourceMethod.getMethod().getAnnotation(ConsumeMime.class);
            resourceMethod.getSupportedInputTypes().addAll(MediaTypeHelper.createMediaTypes(consumeMimeAnnotation));
        } else {
            resourceMethod.getSupportedInputTypes().addAll(MediaTypeHelper.createMediaTypes(classScopeConsumeMimeAnnotation));
        }
    }

    private static final void findOutProduceMimeTypes(AbstractResourceMethod resourceMethod, ProduceMime classScopeProduceMimeAnnotation) {
        if (resourceMethod.getMethod().isAnnotationPresent(ProduceMime.class)) {
            ProduceMime produceMimeAnnotation = resourceMethod.getMethod().getAnnotation(ProduceMime.class);
            resourceMethod.getSupportedOutputTypes().addAll(MediaTypeHelper.createMediaTypes(produceMimeAnnotation));
        } else {
            resourceMethod.getSupportedOutputTypes().addAll(MediaTypeHelper.createMediaTypes(classScopeProduceMimeAnnotation));
        }
    }

    private static final void workOutConstructorsList(AbstractResource resource, Constructor[] ctorArray, boolean isEncoded) {
        if (null != ctorArray) {
            for (Constructor ctor : ctorArray) {
                AbstractResourceConstructor aCtor = new AbstractResourceConstructor(ctor);
                IntrospectionModeller.processParameters((Parameterized)aCtor, ctor, isEncoded);
                resource.getConstructors().add(aCtor);
            }
        }
    }

    private static final void workOutResourceMethodsList(AbstractResource resource, MethodList methodList, boolean isEncoded, ConsumeMime classScopeConsumeMimeAnnotation, ProduceMime classScopeProduceMimeAnnotation) {
        for (Method method : methodList.hasMetaAnnotation(HttpMethod.class).hasNotAnnotation(Path.class)) {
            AbstractResourceMethod resourceMethod = new AbstractResourceMethod(resource, method, IntrospectionModeller.getMetaAnnotations(method, HttpMethod.class).get(0).value());
            IntrospectionModeller.findOutConsumeMimeTypes(resourceMethod, classScopeConsumeMimeAnnotation);
            IntrospectionModeller.findOutProduceMimeTypes(resourceMethod, classScopeProduceMimeAnnotation);
            IntrospectionModeller.processParameters((Parameterized)resourceMethod, resourceMethod.getMethod(), isEncoded);
            resource.getResourceMethods().add(resourceMethod);
        }
    }

    private static final void workOutSubResourceMethodsList(AbstractResource resource, MethodList methodList, boolean isEncoded, ConsumeMime classScopeConsumeMimeAnnotation, ProduceMime classScopeProduceMimeAnnotation) {
        for (Method method : methodList.hasMetaAnnotation(HttpMethod.class).hasAnnotation(Path.class)) {
            Path mPathAnnotation = method.getAnnotation(Path.class);
            AbstractSubResourceMethod subResourceMethod = new AbstractSubResourceMethod(resource, method, new UriPathValue(mPathAnnotation.value(), mPathAnnotation.encode(), mPathAnnotation.limited()), IntrospectionModeller.getMetaAnnotations(method, HttpMethod.class).get(0).value());
            IntrospectionModeller.findOutConsumeMimeTypes(subResourceMethod, classScopeConsumeMimeAnnotation);
            IntrospectionModeller.findOutProduceMimeTypes(subResourceMethod, classScopeProduceMimeAnnotation);
            IntrospectionModeller.processParameters((Parameterized)subResourceMethod, subResourceMethod.getMethod(), isEncoded);
            resource.getSubResourceMethods().add(subResourceMethod);
        }
    }

    private static final <T extends Annotation> List<T> getMetaAnnotations(Method m, Class<T> annotation) {
        ArrayList<T> ma = new ArrayList<T>();
        for (Annotation a : m.getAnnotations()) {
            if (a.annotationType().getAnnotation(annotation) == null) continue;
            ma.add(a.annotationType().getAnnotation(annotation));
        }
        return ma;
    }

    private static final void workOutSubResourceLocatorsList(AbstractResource resource, MethodList methodList, boolean isEncoded) {
        for (Method method : methodList.hasNotMetaAnnotation(HttpMethod.class).hasAnnotation(Path.class)) {
            Path mPathAnnotation = method.getAnnotation(Path.class);
            AbstractSubResourceLocator subResourceLocator = new AbstractSubResourceLocator(method, new UriPathValue(mPathAnnotation.value(), mPathAnnotation.encode(), mPathAnnotation.limited()));
            IntrospectionModeller.processParameters((Parameterized)subResourceLocator, subResourceLocator.getMethod(), isEncoded);
            resource.getSubResourceLocators().add(subResourceLocator);
        }
    }

    private static final void processParameters(Parameterized parametrized, Constructor ctor, boolean isEncoded) {
        IntrospectionModeller.processParameters(ctor.toString(), parametrized, null != ctor.getAnnotation(Encoded.class) || isEncoded, ctor.getParameterTypes(), ctor.getGenericParameterTypes(), ctor.getParameterAnnotations());
    }

    private static final void processParameters(Parameterized parametrized, Method method, boolean isEncoded) {
        IntrospectionModeller.processParameters(method.toString(), parametrized, null != method.getAnnotation(Encoded.class) || isEncoded, method.getParameterTypes(), method.getGenericParameterTypes(), method.getParameterAnnotations());
    }

    private static final void processParameters(String nameForLogging, Parameterized parametrized, boolean isEncoded, Class[] parameterTypes, Type[] genericParameterTypes, Annotation[][] parameterAnnotations) {
        for (int i = 0; i < parameterTypes.length; ++i) {
            Parameter parameter = IntrospectionModeller.createParameter(nameForLogging, i + 1, isEncoded, parameterTypes[i], genericParameterTypes[i], parameterAnnotations[i]);
            if (null == parameter) {
                parametrized.getParameters().removeAll(parametrized.getParameters());
                break;
            }
            parametrized.getParameters().add(parameter);
        }
    }

    private static Map<Class, ParamAnnotationHelper> createParamAnotHelperMap() {
        WeakHashMap<Class<PathParam>, ParamAnnotationHelper> m = new WeakHashMap<Class<PathParam>, ParamAnnotationHelper>();
        m.put(Context.class, new ParamAnnotationHelper(){

            public String getValueOf(Annotation a) {
                return null;
            }

            public Parameter.Source getSource() {
                return Parameter.Source.CONTEXT;
            }
        });
        m.put(HeaderParam.class, new ParamAnnotationHelper(){

            public String getValueOf(Annotation a) {
                return ((HeaderParam)a).value();
            }

            public Parameter.Source getSource() {
                return Parameter.Source.HEADER;
            }
        });
        m.put(MatrixParam.class, new ParamAnnotationHelper(){

            public String getValueOf(Annotation a) {
                return ((MatrixParam)a).value();
            }

            public Parameter.Source getSource() {
                return Parameter.Source.MATRIX;
            }
        });
        m.put(QueryParam.class, new ParamAnnotationHelper(){

            public String getValueOf(Annotation a) {
                return ((QueryParam)a).value();
            }

            public Parameter.Source getSource() {
                return Parameter.Source.QUERY;
            }
        });
        m.put(PathParam.class, new ParamAnnotationHelper(){

            public String getValueOf(Annotation a) {
                return ((PathParam)a).value();
            }

            public Parameter.Source getSource() {
                return Parameter.Source.URI;
            }
        });
        return Collections.unmodifiableMap(m);
    }

    private static final Parameter createParameter(String nameForLogging, int order, boolean isEncoded, Class<?> paramClass, Type paramType, Annotation[] annotations) {
        if (null == annotations) {
            return null;
        }
        Parameter.Source paramSource = null;
        String paramName = null;
        boolean paramEncoded = isEncoded;
        String paramDefault = null;
        for (Annotation annotation : annotations) {
            if (ANOT_HELPER_MAP.containsKey(annotation.annotationType())) {
                ParamAnnotationHelper helper = ANOT_HELPER_MAP.get(annotation.annotationType());
                if (null != paramSource && LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning(ImplMessages.AMBIGUOUS_PARAMETER(nameForLogging, Integer.toString(order)));
                }
                paramSource = helper.getSource();
                paramName = helper.getValueOf(annotation);
                continue;
            }
            if (Encoded.class == annotation.annotationType()) {
                paramEncoded = true;
                continue;
            }
            if (DefaultValue.class != annotation.annotationType()) continue;
            paramDefault = ((DefaultValue)annotation).value();
        }
        if (paramSource == null) {
            paramSource = Parameter.Source.ENTITY;
        }
        return new Parameter(paramSource, paramName, paramType, paramClass, paramEncoded, paramDefault);
    }

    private static final boolean isNotPublic(Method method) {
        assert (null != method);
        return !Modifier.isPublic(method.getModifiers());
    }

    private static void logNonPublicMethods(Class resourceClass) {
        assert (null != resourceClass);
        if (!LOGGER.isLoggable(Level.WARNING)) {
            return;
        }
        MethodList declaredMethods = new MethodList(resourceClass.getDeclaredMethods());
        for (Method method : declaredMethods.hasMetaAnnotation(HttpMethod.class).hasNotAnnotation(Path.class)) {
            if (!IntrospectionModeller.isNotPublic(method)) continue;
            LOGGER.warning(ImplMessages.NON_PUB_RES_METHOD(method.toGenericString()));
        }
        for (Method method : declaredMethods.hasMetaAnnotation(HttpMethod.class).hasAnnotation(Path.class)) {
            if (!IntrospectionModeller.isNotPublic(method)) continue;
            LOGGER.warning(ImplMessages.NON_PUB_SUB_RES_METHOD(method.toGenericString()));
        }
        for (Method method : declaredMethods.hasNotMetaAnnotation(HttpMethod.class).hasAnnotation(Path.class)) {
            if (!IntrospectionModeller.isNotPublic(method)) continue;
            LOGGER.warning(ImplMessages.NON_PUB_SUB_RES_LOC(method.toGenericString()));
        }
    }

    private static interface ParamAnnotationHelper {
        public String getValueOf(Annotation var1);

        public Parameter.Source getSource();
    }
}

