/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.provider.entity;

import com.sun.ws.rest.impl.ImplMessages;
import com.sun.ws.rest.impl.provider.entity.AbstractJAXBElementProvider;
import com.sun.ws.rest.impl.util.ThrowHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.ws.rs.ConsumeMime;
import javax.ws.rs.ProduceMime;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.jettison.badgerfish.BadgerFishXMLStreamReader;
import org.codehaus.jettison.badgerfish.BadgerFishXMLStreamWriter;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ProduceMime(value={"application/json"})
@ConsumeMime(value={"application/json"})
public final class JSONJAXBElementProvider
extends AbstractJAXBElementProvider {
    public Object readFrom(Class<Object> type, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream entityStream) throws IOException {
        try {
            JAXBContext context = this.getJAXBContext(type);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            return unmarshaller.unmarshal((XMLStreamReader)new BadgerFishXMLStreamReader(new JSONObject(this.readFromAsString(entityStream))));
        }
        catch (JAXBException cause) {
            throw ThrowHelper.withInitCause((Exception)((Object)cause), new IOException(ImplMessages.ERROR_MARSHALLING_JAXB(type)));
        }
        catch (XMLStreamException xmlStreamException) {
            throw ThrowHelper.withInitCause(xmlStreamException, new IOException(ImplMessages.ERROR_PARSING_JSON_OBJECT()));
        }
        catch (JSONException jsonException) {
            throw ThrowHelper.withInitCause((Exception)((Object)jsonException), new IOException(ImplMessages.ERROR_PARSING_JSON_OBJECT()));
        }
    }

    public void writeTo(Object t, MediaType mediaType, MultivaluedMap<String, Object> headers, OutputStream entityStream) throws IOException {
        try {
            JAXBContext context = this.getJAXBContext(t.getClass());
            Marshaller marshaller = context.createMarshaller();
            marshaller.marshal(t, (XMLStreamWriter)new BadgerFishXMLStreamWriter((Writer)new OutputStreamWriter(entityStream)));
        }
        catch (JAXBException cause) {
            throw ThrowHelper.withInitCause((Exception)((Object)cause), new IOException(ImplMessages.ERROR_MARSHALLING_JAXB(t.getClass())));
        }
    }
}

