/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.provider.entity;

import com.sun.ws.rest.impl.provider.entity.AbstractTypeEntityProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MimeMultipartProvider
extends AbstractTypeEntityProvider<MimeMultipart> {
    @Override
    public boolean supports(Class type) {
        return type == MimeMultipart.class;
    }

    public MimeMultipart readFrom(Class<MimeMultipart> type, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream entityStream) throws IOException {
        if (mediaType == null) {
            mediaType = new MediaType("multipart", "form-data");
        }
        ByteArrayDataSource ds = new ByteArrayDataSource(entityStream, mediaType.toString());
        try {
            return new MimeMultipart((DataSource)ds);
        }
        catch (MessagingException cause) {
            IOException effect = new IOException("Error reading entity as MimeMultipart");
            effect.initCause(cause);
            throw effect;
        }
    }

    public void writeTo(MimeMultipart t, MediaType mediaType, MultivaluedMap<String, Object> headers, OutputStream entityStream) throws IOException {
        try {
            t.writeTo(entityStream);
        }
        catch (MessagingException e) {
            IOException io = new IOException("Error writing entity from MimeMultipart");
            throw (IOException)io.initCause(e);
        }
    }
}

