/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.provider.header;

import com.sun.ws.rest.impl.http.header.reader.HttpHeaderReaderImpl;
import com.sun.ws.rest.impl.http.header.writer.WriterUtil;
import com.sun.ws.rest.spi.HeaderDelegateProvider;
import java.text.ParseException;
import javax.ws.rs.core.EntityTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityTagProvider
implements HeaderDelegateProvider<EntityTag> {
    @Override
    public boolean supports(Class<?> type) {
        return type == EntityTag.class;
    }

    public String toString(EntityTag header) {
        StringBuilder b = new StringBuilder();
        if (header.isWeak()) {
            b.append("W/");
        }
        WriterUtil.appendQuoted(b, header.getValue());
        return b.toString();
    }

    public EntityTag fromString(String header) {
        boolean weak = false;
        if (header.startsWith("W/")) {
            header = header.substring(2);
            weak = true;
        }
        HttpHeaderReaderImpl reader = new HttpHeaderReaderImpl(header);
        try {
            EntityTag eTag = new EntityTag(reader.nextQuotedString(), weak);
            return eTag;
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

