/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.spi.resource;

import com.sun.ws.rest.api.container.ContainerException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Injectable<T extends Annotation, V> {
    public abstract Class<T> getAnnotationClass();

    public void inject(Object resource, Field f) {
        if (this.getFieldValue(resource, f) != null) {
            return;
        }
        T a = f.getAnnotation(this.getAnnotationClass());
        if (a == null) {
            return;
        }
        V value = this.getInjectableValue(a);
        if (value != null) {
            this.setFieldValue(resource, f, value);
        }
    }

    public abstract V getInjectableValue(T var1);

    private void setFieldValue(final Object resource, final Field f, final Object value) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    f.set(resource, value);
                    return null;
                }
                catch (IllegalAccessException e) {
                    throw new ContainerException(e);
                }
            }
        });
    }

    private Object getFieldValue(final Object resource, final Field f) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    return f.get(resource);
                }
                catch (IllegalAccessException e) {
                    throw new ContainerException(e);
                }
            }
        });
    }
}

