/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.user.provider.file;

import com.opensymphony.util.ClassLoaderUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class FileEntitiesCache {
    protected static final Log log = LogFactory.getLog((Class)FileEntitiesCache.class);
    protected String storeFile;
    protected String storeFileType;

    public FileEntitiesCache(String storeFile, String storeFileType) {
        this.storeFile = storeFile;
        this.storeFileType = storeFileType;
        if (storeFile == null) {
            log.fatal((Object)"property storeFile must be specified");
        }
        if (storeFileType == null) {
            log.fatal((Object)"property storeFileType must be specified; one of (file,resource)");
        }
        if (!storeFileType.equalsIgnoreCase("file") && !storeFileType.equalsIgnoreCase("resource")) {
            log.fatal((Object)"property storeFileType must be one of (file,resource)");
        }
    }

    public abstract boolean load();

    public abstract boolean store();

    protected InputStream getInputStreamFromStoreFile() throws IOException {
        if (this.storeFileType.equalsIgnoreCase("file")) {
            return new FileInputStream(this.storeFile);
        }
        if (this.storeFileType.equalsIgnoreCase("resource")) {
            return ClassLoaderUtil.getResourceAsStream((String)this.storeFile, this.getClass());
        }
        log.fatal((Object)"property storeFileType must be one of (file,resource)");
        return null;
    }
}

