/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SVNErrorManager {
    public static void cancel(String message) throws SVNCancelException {
        SVNDebugLog.getDefaultLog().info(message);
        throw new SVNCancelException(SVNErrorMessage.create(SVNErrorCode.CANCELLED, message));
    }

    public static void authenticationFailed(String message, Object messageObject) throws SVNAuthenticationException {
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, message, messageObject);
        SVNDebugLog.getDefaultLog().info(err.getMessage());
        throw new SVNAuthenticationException(err);
    }

    public static void error(SVNErrorMessage err) throws SVNException {
        SVNErrorManager.error(err, true);
    }

    public static void error(SVNErrorMessage err, boolean log) throws SVNException {
        if (err == null) {
            err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN);
        }
        if (log) {
            SVNDebugLog.getDefaultLog().info(err.getFullMessage());
        }
        if (err.getErrorCode() == SVNErrorCode.CANCELLED) {
            throw new SVNCancelException(err);
        }
        if (err.getErrorCode().isAuthentication()) {
            throw new SVNAuthenticationException(err);
        }
        throw new SVNException(err);
    }

    public static void error(SVNErrorMessage err, Throwable cause) throws SVNException {
        if (err == null) {
            err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN);
        }
        SVNDebugLog.getDefaultLog().info(err.getMessage());
        if (err.getErrorCode() == SVNErrorCode.CANCELLED) {
            throw new SVNCancelException(err);
        }
        if (err.getErrorCode().isAuthentication()) {
            throw new SVNAuthenticationException(err);
        }
        throw new SVNException(err, cause);
    }

    public static void error(SVNErrorMessage err1, SVNErrorMessage err2) throws SVNException {
        if (err1 == null) {
            SVNErrorManager.error(err2);
        } else if (err2 == null) {
            SVNErrorManager.error(err1);
        }
        err1.setChildErrorMessage(err2);
        SVNDebugLog.getDefaultLog().info(err1.getMessage());
        if (err1.getErrorCode() == SVNErrorCode.CANCELLED || err2.getErrorCode() == SVNErrorCode.CANCELLED) {
            throw new SVNCancelException(err1);
        }
        if (err1.getErrorCode().isAuthentication() || err2.getErrorCode().isAuthentication()) {
            throw new SVNAuthenticationException(err1);
        }
        throw new SVNException(err1);
    }

    public static void error(SVNErrorMessage err1, SVNErrorMessage err2, Throwable cause) throws SVNException {
        if (err1 == null) {
            SVNErrorManager.error(err2, cause);
        } else if (err2 == null) {
            SVNErrorManager.error(err1, cause);
        }
        err1.setChildErrorMessage(err2);
        SVNDebugLog.getDefaultLog().info(err1.getMessage());
        if (err1.getErrorCode() == SVNErrorCode.CANCELLED || err2.getErrorCode() == SVNErrorCode.CANCELLED) {
            throw new SVNCancelException(err1);
        }
        if (err1.getErrorCode().isAuthentication() || err2.getErrorCode().isAuthentication()) {
            throw new SVNAuthenticationException(err1, cause);
        }
        throw new SVNException(err1, cause);
    }
}

