/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.cli.SVNCommandLine;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SVN {
    private static Set ourArguments = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        block25: {
            if (args == null || args.length < 1) {
                System.err.println("usage: jsvn commandName commandArguments");
                System.exit(1);
            }
            StringBuffer commandLineString = new StringBuffer();
            for (int i = 0; i < args.length; ++i) {
                commandLineString.append(args[i] + (i < args.length - 1 ? " " : ""));
            }
            SVNCommandLine commandLine = null;
            try {
                try {
                    commandLine = new SVNCommandLine(args, ourArguments);
                }
                catch (SVNException e) {
                    SVNDebugLog.getDefaultLog().info((Throwable)e);
                    System.err.println(e.getMessage());
                    System.exit(1);
                }
                String commandName = commandLine.getCommandName();
                SVNCommand command = SVNCommand.getCommand(commandName);
                if (command != null) {
                    boolean isSuccess;
                    block24: {
                        if (SVNCommand.isForceLogCommand(commandName) && !commandLine.hasArgument(SVNArgument.FORCE_LOG)) {
                            File file;
                            String msg;
                            if (commandLine.hasArgument(SVNArgument.FILE)) {
                                File file2 = new File((String)commandLine.getArgumentValue(SVNArgument.FILE));
                                SVNStatusClient stClient = new SVNStatusClient((ISVNAuthenticationManager)null, null);
                                try {
                                    SVNStatus status = stClient.doStatus(file2.getAbsoluteFile(), false);
                                    if (status != null && status.getContentsStatus() != SVNStatusType.STATUS_UNVERSIONED && status.getContentsStatus() != SVNStatusType.STATUS_IGNORED && status.getContentsStatus() != SVNStatusType.STATUS_EXTERNAL) {
                                        if ("lock".equals(commandName)) {
                                            System.err.println("svn: Lock comment file is a versioned file; use '--force-log' to override");
                                        } else {
                                            System.err.println("svn: Log message file is a versioned file; use '--force-log' to override");
                                        }
                                        System.exit(1);
                                    }
                                }
                                catch (SVNException e) {
                                    // empty catch block
                                }
                            }
                            if (commandLine.hasArgument(SVNArgument.MESSAGE) && !"".equals(msg = (String)commandLine.getArgumentValue(SVNArgument.MESSAGE)) && msg != null && SVNFileType.getType((File)(file = new File(msg))) != SVNFileType.NONE) {
                                if ("lock".equals(commandName)) {
                                    System.err.println("svn: The lock comment is a path name (was -F intended?); use '--force-log' to override");
                                } else {
                                    System.err.println("svn: The log message is a path name (was -F intended?); use '--force-log' to override");
                                }
                                System.exit(1);
                            }
                        }
                        DAVRepositoryFactory.setup();
                        SVNRepositoryFactoryImpl.setup();
                        FSRepositoryFactory.setup();
                        command.setCommandLine(commandLine);
                        isSuccess = true;
                        try {
                            try {
                                command.run(System.out, System.err);
                            }
                            catch (SVNException e) {
                                System.err.println(e.getMessage());
                                SVNDebugLog.getDefaultLog().info((Throwable)e);
                                isSuccess = false;
                                Object var9_15 = null;
                                if (command.getClientManager() != null) {
                                    command.getClientManager().shutdownConnections(true);
                                }
                                break block24;
                            }
                            Object var9_14 = null;
                            if (command.getClientManager() == null) break block24;
                        }
                        catch (Throwable throwable) {
                            Object var9_16 = null;
                            if (command.getClientManager() != null) {
                                command.getClientManager().shutdownConnections(true);
                            }
                            throw throwable;
                        }
                        command.getClientManager().shutdownConnections(true);
                    }
                    if (!isSuccess) {
                        System.exit(1);
                    }
                    break block25;
                }
                System.err.println("error: unknown command name '" + commandName + "'");
                System.exit(1);
            }
            catch (Throwable th) {
                SVNDebugLog.getDefaultLog().info(th);
                System.exit(-1);
            }
        }
        System.exit(0);
    }

    static {
        ourArguments.add(SVNArgument.PASSWORD);
        ourArguments.add(SVNArgument.USERNAME);
        ourArguments.add(SVNArgument.CONFIG_DIR);
        ourArguments.add(SVNArgument.NON_RECURSIVE);
        ourArguments.add(SVNArgument.RECURSIVE);
        ourArguments.add(SVNArgument.VERBOSE);
        ourArguments.add(SVNArgument.QUIET);
        ourArguments.add(SVNArgument.SHOW_UPDATES);
        ourArguments.add(SVNArgument.NO_IGNORE);
        ourArguments.add(SVNArgument.MESSAGE);
        ourArguments.add(SVNArgument.REVISION);
        ourArguments.add(SVNArgument.FORCE);
        ourArguments.add(SVNArgument.FORCE_LOG);
        ourArguments.add(SVNArgument.FILE);
        ourArguments.add(SVNArgument.EDITOR_CMD);
        ourArguments.add(SVNArgument.STRICT);
        ourArguments.add(SVNArgument.NO_UNLOCK);
        ourArguments.add(SVNArgument.NO_AUTH_CACHE);
        ourArguments.add(SVNArgument.RELOCATE);
        ourArguments.add(SVNArgument.EOL_STYLE);
        ourArguments.add(SVNArgument.NO_DIFF_DELETED);
        ourArguments.add(SVNArgument.USE_ANCESTRY);
        ourArguments.add(SVNArgument.OLD);
        ourArguments.add(SVNArgument.NEW);
        ourArguments.add(SVNArgument.DRY_RUN);
        ourArguments.add(SVNArgument.IGNORE_ANCESTRY);
        ourArguments.add(SVNArgument.NO_AUTO_PROPS);
        ourArguments.add(SVNArgument.AUTO_PROPS);
        ourArguments.add(SVNArgument.REV_PROP);
        ourArguments.add(SVNArgument.INCREMENTAL);
        ourArguments.add(SVNArgument.XML);
        ourArguments.add(SVNArgument.LIMIT);
        ourArguments.add(SVNArgument.STOP_ON_COPY);
        ourArguments.add(SVNArgument.NON_INTERACTIVE);
        ourArguments.add(SVNArgument.CHANGE);
        ourArguments.add(SVNArgument.SUMMARIZE);
        ourArguments.add(SVNArgument.EXTENSIONS);
        ourArguments.add(SVNArgument.IGNORE_ALL_WS);
        ourArguments.add(SVNArgument.IGNORE_EOL_STYLE);
        ourArguments.add(SVNArgument.IGNORE_WS_CHANGE);
    }
}

