/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.tmatesoft.svn.core.SVNException;

public abstract class SVNArgument {
    public static final SVNArgument PASSWORD = SVNArgument.createStringArgument(new String[]{"--password"});
    public static final SVNArgument USERNAME = SVNArgument.createStringArgument(new String[]{"--username"});
    public static final SVNArgument CONFIG_DIR = SVNArgument.createStringArgument(new String[]{"--config-dir"});
    public static final SVNArgument NON_RECURSIVE = SVNArgument.createUnaryArgument(new String[]{"--non-recursive", "-N"});
    public static final SVNArgument NO_AUTO_PROPS = SVNArgument.createUnaryArgument(new String[]{"--no-auto-props"});
    public static final SVNArgument AUTO_PROPS = SVNArgument.createUnaryArgument(new String[]{"--auto-props"});
    public static final SVNArgument IGNORE_ANCESTRY = SVNArgument.createUnaryArgument(new String[]{"--ignore-ancestry"});
    public static final SVNArgument REV_PROP = SVNArgument.createUnaryArgument(new String[]{"--revprop"});
    public static final SVNArgument RECURSIVE = SVNArgument.createUnaryArgument(new String[]{"--recursive", "-R"});
    public static final SVNArgument VERBOSE = SVNArgument.createUnaryArgument(new String[]{"--verbose", "-v"});
    public static final SVNArgument NO_DIFF_DELETED = SVNArgument.createUnaryArgument(new String[]{"--no-diff-deleted"});
    public static final SVNArgument NO_DIFF_ADDED = SVNArgument.createUnaryArgument(new String[]{"--no-diff-added"});
    public static final SVNArgument DIFF_COPY_FROM = SVNArgument.createUnaryArgument(new String[]{"--diff-copy-from"});
    public static final SVNArgument USE_ANCESTRY = SVNArgument.createUnaryArgument(new String[]{"--notice-ancestry"});
    public static final SVNArgument QUIET = SVNArgument.createUnaryArgument(new String[]{"--quiet", "-q"});
    public static final SVNArgument SHOW_UPDATES = SVNArgument.createUnaryArgument(new String[]{"--show-updates", "-u"});
    public static final SVNArgument NO_IGNORE = SVNArgument.createUnaryArgument(new String[]{"--no-ignore"});
    public static final SVNArgument MESSAGE = SVNArgument.createStringArgument(new String[]{"--message", "-m"});
    public static final SVNArgument REVISION = SVNArgument.createStringArgument(new String[]{"--revision", "-r"});
    public static final SVNArgument OLD = SVNArgument.createStringArgument(new String[]{"--old"});
    public static final SVNArgument NEW = SVNArgument.createStringArgument(new String[]{"--new"});
    public static final SVNArgument NO_AUTH_CACHE = SVNArgument.createUnaryArgument(new String[]{"--no-auth-cache"});
    public static final SVNArgument FORCE = SVNArgument.createUnaryArgument(new String[]{"--force"});
    public static final SVNArgument FORCE_LOG = SVNArgument.createUnaryArgument(new String[]{"--force-log"});
    public static final SVNArgument FILE = SVNArgument.createStringArgument(new String[]{"-F"});
    public static final SVNArgument EDITOR_CMD = SVNArgument.createStringArgument(new String[]{"--editor-cmd"});
    public static final SVNArgument STRICT = SVNArgument.createUnaryArgument(new String[]{"--strict"});
    public static final SVNArgument STOP_ON_COPY = SVNArgument.createUnaryArgument(new String[]{"--stop-on-copy"});
    public static final SVNArgument NO_UNLOCK = SVNArgument.createUnaryArgument(new String[]{"--no-unlock"});
    public static final SVNArgument RELOCATE = SVNArgument.createUnaryArgument(new String[]{"--relocate"});
    public static final SVNArgument EOL_STYLE = SVNArgument.createStringArgument(new String[]{"--native-eol"});
    public static final SVNArgument DRY_RUN = SVNArgument.createUnaryArgument(new String[]{"--dry-run"});
    public static final SVNArgument INCREMENTAL = SVNArgument.createUnaryArgument(new String[]{"--incremental"});
    public static final SVNArgument XML = SVNArgument.createUnaryArgument(new String[]{"--xml"});
    public static final SVNArgument LIMIT = SVNArgument.createStringArgument(new String[]{"--limit"});
    public static final SVNArgument NON_INTERACTIVE = SVNArgument.createUnaryArgument(new String[]{"--non-interactive"});
    public static final SVNArgument CHANGE = SVNArgument.createStringArgument(new String[]{"--change", "-c"});
    public static final SVNArgument SUMMARIZE = SVNArgument.createUnaryArgument(new String[]{"--summarize"});
    public static final SVNArgument EXTENSIONS = SVNArgument.createUnaryArgument(new String[]{"-x", "--extensions"});
    public static final SVNArgument IGNORE_WS_CHANGE = SVNArgument.createUnaryArgument(new String[]{"-b", "--ignore-space-change"});
    public static final SVNArgument IGNORE_ALL_WS = SVNArgument.createUnaryArgument(new String[]{"-w", "--ignore-all-space"});
    public static final SVNArgument IGNORE_EOL_STYLE = SVNArgument.createUnaryArgument(new String[]{"--ignore-eol-style"});
    public static final SVNArgument FS_TYPE = SVNArgument.createStringArgument(new String[]{"--fs-type"});
    public static final SVNArgument PRE_14_COMPATIBLE = SVNArgument.createUnaryArgument(new String[]{"--pre-1.4-compatible"});
    public static final SVNArgument BDB_TXN_NOSYNC = SVNArgument.createUnaryArgument(new String[]{"--bdb-txn-nosync"});
    public static final SVNArgument BDB_LOG_KEEP = SVNArgument.createUnaryArgument(new String[]{"--bdb-log-keep"});
    public static final SVNArgument DELTAS = SVNArgument.createUnaryArgument(new String[]{"--deltas"});
    public static final SVNArgument IGNORE_UUID = SVNArgument.createUnaryArgument(new String[]{"--ignore-uuid"});
    public static final SVNArgument FORCE_UUID = SVNArgument.createUnaryArgument(new String[]{"--force-uuid"});
    public static final SVNArgument USE_PRECOMMIT_HOOK = SVNArgument.createUnaryArgument(new String[]{"--use-pre-commit-hook"});
    public static final SVNArgument USE_POSTCOMMIT_HOOK = SVNArgument.createUnaryArgument(new String[]{"--use-post-commit-hook"});
    public static final SVNArgument PARENT_DIR = SVNArgument.createStringArgument(new String[]{"--parent-dir"});
    public static final SVNArgument TRANSACTION = SVNArgument.createStringArgument(new String[]{"--transaction", "-t"});
    public static final SVNArgument COPY_INFO = SVNArgument.createUnaryArgument(new String[]{"--copy-info"});
    public static final SVNArgument SHOW_IDS = SVNArgument.createUnaryArgument(new String[]{"--show-ids"});
    public static final SVNArgument FULL_PATHS = SVNArgument.createUnaryArgument(new String[]{"--full-paths"});
    private ArrayList myNames = new ArrayList();

    public static SVNArgument findArgument(String name, Set validArguments) {
        Iterator arguments = validArguments.iterator();
        while (arguments.hasNext()) {
            SVNArgument argument = (SVNArgument)arguments.next();
            Iterator names = argument.names();
            while (names.hasNext()) {
                String argumentName = (String)names.next();
                if (!argumentName.equals(name)) continue;
                return argument;
            }
        }
        return null;
    }

    private static SVNArgument createStringArgument(String[] names) {
        return new SVNStringArgument(names);
    }

    static SVNArgument createUnaryArgument(String[] names) {
        return new SVNUnaryArgument(names);
    }

    private SVNArgument(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            this.myNames.add(names[i]);
        }
    }

    public Iterator names() {
        return this.myNames.iterator();
    }

    public abstract boolean hasValue();

    public abstract Object parseValue(String var1) throws SVNException;

    private static class SVNStringArgument
    extends SVNArgument {
        protected SVNStringArgument(String[] names) {
            super(names);
        }

        public boolean hasValue() {
            return true;
        }

        public Object parseValue(String value) throws SVNException {
            return value;
        }
    }

    private static class SVNUnaryArgument
    extends SVNArgument {
        protected SVNUnaryArgument(String[] names) {
            super(names);
        }

        public boolean hasValue() {
            return false;
        }

        public Object parseValue(String value) throws SVNException {
            return null;
        }
    }
}

