/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Date;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.admin.ISVNAdminEventHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminClient;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEvent;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;

public class SVNAdminListLocksCommand
extends SVNCommand
implements ISVNAdminEventHandler {
    private PrintStream myOut;

    public void run(PrintStream out, PrintStream err) throws SVNException {
        if (!this.getCommandLine().hasPaths()) {
            SVNCommand.println(out, "svnadmin: Repository argument required");
            System.exit(1);
        }
        File reposRoot = new File(this.getCommandLine().getPathAt(0));
        this.myOut = out;
        SVNAdminClient adminClient = this.getClientManager().getAdminClient();
        adminClient.setEventHandler((ISVNEventHandler)this);
        adminClient.doListLocks(reposRoot);
    }

    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }

    public void handleAdminEvent(SVNAdminEvent event, double progress) throws SVNException {
        SVNLock lock;
        if (event != null && event.getAction() == SVNAdminEventAction.LOCK_LISTED && (lock = event.getLock()) != null) {
            String creationDate = SVNTimeUtil.formatDate((Date)lock.getCreationDate());
            String expirationDate = lock.getExpirationDate() != null ? SVNTimeUtil.formatDate((Date)lock.getExpirationDate()) : "";
            int commentLines = 0;
            if (lock.getComment() != null) {
                commentLines = SVNAdminListLocksCommand.getLinesCount(lock.getComment());
            }
            SVNCommand.println(this.myOut, "Path: " + lock.getPath());
            SVNCommand.println(this.myOut, "UUID Token: " + lock.getID());
            SVNCommand.println(this.myOut, "Owner: " + lock.getOwner());
            SVNCommand.println(this.myOut, "Created: " + creationDate);
            SVNCommand.println(this.myOut, "Expires: " + expirationDate);
            if (commentLines != 1) {
                SVNCommand.println(this.myOut, "Comment (" + commentLines + " lines):");
                SVNCommand.println(this.myOut, lock.getComment() != null ? lock.getComment() : "");
            } else {
                SVNCommand.println(this.myOut, "Comment (" + commentLines + " line):");
                SVNCommand.println(this.myOut, lock.getComment() != null ? lock.getComment() : "");
            }
            SVNCommand.println(this.myOut, "");
        }
    }

    public void checkCancelled() throws SVNCancelException {
    }

    public void handleEvent(SVNEvent event, double progress) throws SVNException {
    }
}

