/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.admin.SVNLookClient;

public class SVNLookAuthorCommand
extends SVNCommand {
    public void run(PrintStream out, PrintStream err) throws SVNException {
        String author;
        if (!this.getCommandLine().hasPaths()) {
            SVNCommand.println(err, "jsvnlook: Repository argument required");
            System.exit(1);
        }
        File reposRoot = new File(this.getCommandLine().getPathAt(0));
        SVNRevision revision = SVNRevision.HEAD;
        SVNLookClient lookClient = this.getClientManager().getLookClient();
        if (this.getCommandLine().hasArgument(SVNArgument.TRANSACTION)) {
            String transactionName = (String)this.getCommandLine().getArgumentValue(SVNArgument.TRANSACTION);
            String author2 = lookClient.doGetAuthor(reposRoot, transactionName);
            SVNCommand.println(out, author2 != null ? author2 : "");
            return;
        }
        if (this.getCommandLine().hasArgument(SVNArgument.REVISION)) {
            revision = SVNRevision.parse((String)((String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION)));
        }
        SVNCommand.println(out, (author = lookClient.doGetAuthor(reposRoot, revision)) != null ? author : "");
    }

    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }
}

