/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.xml.SVNXMLDirEntryHandler;
import org.tmatesoft.svn.core.wc.xml.SVNXMLSerializer;
import org.xml.sax.ContentHandler;

public class SVNLsCommand
extends SVNCommand
implements ISVNDirEntryHandler {
    private PrintStream myPrintStream;
    private boolean myIsVerbose;
    private static final DateFormat LONG_DATE_FORMAT = new SimpleDateFormat("MM' 'dd'  'yyyy");
    private static final DateFormat SHORT_DATE_FORMAT = new SimpleDateFormat("MM' 'dd'  'HH:mm");

    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }

    public void run(PrintStream out, PrintStream err) throws SVNException {
        int i;
        boolean recursive = this.getCommandLine().hasArgument(SVNArgument.RECURSIVE);
        this.myIsVerbose = this.getCommandLine().hasArgument(SVNArgument.VERBOSE);
        this.myPrintStream = out;
        boolean isXml = this.getCommandLine().hasArgument(SVNArgument.XML);
        SVNXMLSerializer serializer = isXml ? new SVNXMLSerializer((OutputStream)this.myPrintStream) : null;
        SVNXMLDirEntryHandler handler = isXml ? new SVNXMLDirEntryHandler((ContentHandler)serializer) : null;
        SVNRevision revision = SVNLsCommand.parseRevision(this.getCommandLine());
        SVNLogClient logClient = this.getClientManager().getLogClient();
        if (!this.getCommandLine().hasURLs() && !this.getCommandLine().hasPaths()) {
            this.getCommandLine().setPathAt(0, "");
        }
        if (handler != null && !this.getCommandLine().hasArgument(SVNArgument.INCREMENTAL)) {
            handler.startDocument();
        }
        for (i = 0; i < this.getCommandLine().getURLCount(); ++i) {
            String url = this.getCommandLine().getURL(i);
            if (handler != null) {
                handler.startTarget(url);
            }
            logClient.doList(SVNURL.parseURIEncoded((String)url), this.getCommandLine().getPegRevision(i), revision == null ? SVNRevision.UNDEFINED : revision, this.myIsVerbose || isXml, recursive, (ISVNDirEntryHandler)(isXml ? handler : this));
            if (handler == null) continue;
            handler.endTarget();
        }
        for (i = 0; i < this.getCommandLine().getPathCount(); ++i) {
            File path = new File(this.getCommandLine().getPathAt(i)).getAbsoluteFile();
            if (handler != null) {
                handler.startTarget(path.getAbsolutePath().replace(File.separatorChar, '/'));
            }
            logClient.doList(path, this.getCommandLine().getPathPegRevision(i), revision == null || !revision.isValid() ? SVNRevision.BASE : revision, this.myIsVerbose || isXml, recursive, (ISVNDirEntryHandler)(isXml ? handler : this));
            if (handler == null) continue;
            handler.endTarget();
        }
        if (handler != null) {
            if (!this.getCommandLine().hasArgument(SVNArgument.INCREMENTAL)) {
                handler.endDocument();
            }
            try {
                serializer.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public void handleDirEntry(SVNDirEntry dirEntry) {
        if (this.myIsVerbose) {
            StringBuffer verbose = new StringBuffer();
            verbose.append(SVNCommand.formatString(dirEntry.getRevision() + "", 7, false));
            verbose.append(' ');
            verbose.append(SVNCommand.formatString(dirEntry.getAuthor() == null ? " ? " : dirEntry.getAuthor(), 16, true));
            verbose.append(' ');
            verbose.append(dirEntry.getLock() != null ? (char)'O' : ' ');
            verbose.append(' ');
            verbose.append(SVNCommand.formatString(dirEntry.getKind() == SVNNodeKind.DIR ? "" : dirEntry.getSize() + "", 10, false));
            verbose.append(' ');
            Date d = dirEntry.getDate();
            String timeStr = "";
            if (d != null) {
                timeStr = System.currentTimeMillis() - d.getTime() < 735614464L ? SHORT_DATE_FORMAT.format(d) : LONG_DATE_FORMAT.format(d);
            }
            verbose.append(SVNCommand.formatString(timeStr, 12, false));
            verbose.append(' ');
            this.myPrintStream.print(verbose.toString());
        }
        this.myPrintStream.print(dirEntry.getRelativePath());
        if (dirEntry.getKind() == SVNNodeKind.DIR) {
            this.myPrintStream.print('/');
        }
        this.myPrintStream.println();
    }

    static {
        SHORT_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        LONG_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

