/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.config.impl;

import com.opensymphony.xwork.config.Configuration;
import com.opensymphony.xwork.config.ConfigurationException;
import com.opensymphony.xwork.config.ConfigurationManager;
import com.opensymphony.xwork.config.ConfigurationProvider;
import com.opensymphony.xwork.config.RuntimeConfiguration;
import com.opensymphony.xwork.config.entities.ActionConfig;
import com.opensymphony.xwork.config.entities.PackageConfig;
import com.opensymphony.xwork.config.entities.ResultTypeConfig;
import com.opensymphony.xwork.config.providers.InterceptorBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultConfiguration
implements Configuration {
    protected static final Log LOG = LogFactory.getLog((Class)(class$com$opensymphony$xwork$config$impl$DefaultConfiguration == null ? (class$com$opensymphony$xwork$config$impl$DefaultConfiguration = DefaultConfiguration.class$("com.opensymphony.xwork.config.impl.DefaultConfiguration")) : class$com$opensymphony$xwork$config$impl$DefaultConfiguration));
    private Map packageContexts = new HashMap();
    private RuntimeConfiguration runtimeConfiguration;
    static /* synthetic */ Class class$com$opensymphony$xwork$config$impl$DefaultConfiguration;

    public PackageConfig getPackageConfig(String name) {
        return (PackageConfig)this.packageContexts.get(name);
    }

    public Set getPackageConfigNames() {
        return this.packageContexts.keySet();
    }

    public Map getPackageConfigs() {
        return this.packageContexts;
    }

    public RuntimeConfiguration getRuntimeConfiguration() {
        return this.runtimeConfiguration;
    }

    public void addPackageConfig(String name, PackageConfig packageContext) {
        this.packageContexts.put(name, packageContext);
    }

    public void destroy() {
    }

    public void rebuildRuntimeConfiguration() {
        this.runtimeConfiguration = this.buildRuntimeConfiguration();
    }

    public synchronized void reload() throws ConfigurationException {
        this.packageContexts.clear();
        Iterator iterator = ConfigurationManager.getConfigurationProviders().iterator();
        while (iterator.hasNext()) {
            ConfigurationProvider provider = (ConfigurationProvider)iterator.next();
            provider.init(this);
        }
        this.rebuildRuntimeConfiguration();
    }

    public void removePackageConfig(String name) {
        PackageConfig toBeRemoved = (PackageConfig)this.packageContexts.get(name);
        if (toBeRemoved != null) {
            Iterator iterator = this.packageContexts.values().iterator();
            while (iterator.hasNext()) {
                PackageConfig packageContext = (PackageConfig)iterator.next();
                packageContext.removeParent(toBeRemoved);
            }
        }
    }

    protected synchronized RuntimeConfiguration buildRuntimeConfiguration() throws ConfigurationException {
        HashMap namespaceActionConfigs = new HashMap();
        Iterator iterator = this.packageContexts.values().iterator();
        while (iterator.hasNext()) {
            PackageConfig packageContext = (PackageConfig)iterator.next();
            if (packageContext.isAbstract()) continue;
            String namespace = packageContext.getNamespace();
            HashMap<String, ActionConfig> configs = (HashMap<String, ActionConfig>)namespaceActionConfigs.get(namespace);
            if (configs == null) {
                configs = new HashMap<String, ActionConfig>();
            }
            Map actionConfigs = packageContext.getAllActionConfigs();
            Iterator actionIterator = actionConfigs.keySet().iterator();
            while (actionIterator.hasNext()) {
                String actionName = (String)actionIterator.next();
                ActionConfig baseConfig = (ActionConfig)actionConfigs.get(actionName);
                configs.put(actionName, this.buildFullActionConfig(packageContext, baseConfig));
            }
            namespaceActionConfigs.put(namespace, configs);
        }
        return new RuntimeConfigurationImpl(namespaceActionConfigs);
    }

    private void setDefaultResults(Map results, PackageConfig packageContext) {
        String defaultResult = packageContext.getFullDefaultResultType();
        Iterator iterator = results.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getValue() != null) continue;
            ResultTypeConfig resultTypeConfig = (ResultTypeConfig)packageContext.getAllResultTypeConfigs().get(defaultResult);
            entry.setValue(resultTypeConfig.getClazz());
        }
    }

    private ActionConfig buildFullActionConfig(PackageConfig packageContext, ActionConfig baseConfig) throws ConfigurationException {
        String defaultInterceptorRefName;
        HashMap params = new HashMap(baseConfig.getParams());
        HashMap results = new HashMap(packageContext.getAllGlobalResults());
        results.putAll(baseConfig.getResults());
        this.setDefaultResults(results, packageContext);
        ArrayList interceptors = new ArrayList(baseConfig.getInterceptors());
        if (interceptors.size() <= 0 && (defaultInterceptorRefName = packageContext.getFullDefaultInterceptorRef()) != null) {
            interceptors.addAll(InterceptorBuilder.constructInterceptorReference(packageContext, defaultInterceptorRefName, new HashMap()));
        }
        List externalRefs = baseConfig.getExternalRefs();
        ActionConfig config = new ActionConfig(baseConfig.getMethodName(), baseConfig.getClassName(), params, results, interceptors, externalRefs, packageContext.getName());
        return config;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class RuntimeConfigurationImpl
    implements RuntimeConfiguration {
        private Map namespaceActionConfigs;

        public RuntimeConfigurationImpl(Map namespaceActionConfigs) {
            this.namespaceActionConfigs = namespaceActionConfigs;
        }

        public synchronized ActionConfig getActionConfig(String namespace, String name) {
            ActionConfig config = null;
            Map actions = (Map)this.namespaceActionConfigs.get(namespace == null ? "" : namespace);
            if (actions != null) {
                config = (ActionConfig)actions.get(name);
            }
            if (config == null && namespace != null && !namespace.trim().equals("") && (actions = (Map)this.namespaceActionConfigs.get("")) != null) {
                config = (ActionConfig)actions.get(name);
            }
            return config;
        }

        public synchronized Map getActionConfigs() {
            return this.namespaceActionConfigs;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer("RuntimeConfiguration - actions are\n");
            Iterator iterator = this.namespaceActionConfigs.keySet().iterator();
            while (iterator.hasNext()) {
                String namespace = (String)iterator.next();
                Map actionConfigs = (Map)this.namespaceActionConfigs.get(namespace);
                Iterator iterator2 = actionConfigs.keySet().iterator();
                while (iterator2.hasNext()) {
                    buff.append(namespace + "/" + iterator2.next() + "\n");
                }
            }
            return buff.toString();
        }
    }
}

