/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye;

import com.cenqua.fisheye.FishEyeClassLoader;
import com.cenqua.fisheye.boot.FileUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FishEyeCtl {
    private static final Map COMMANDS = new HashMap();
    private static final String[] STRING_ARRAY = new String[0];
    public static FishEyeClassLoader CLASSLOADER = null;

    public static void main(String[] args) {
        int rc = FishEyeCtl.mainImpl(args);
        if (rc != 0) {
            System.exit(rc);
        }
    }

    public static int mainImpl(String[] args) {
        FishEyeClassLoader env;
        File fisheyeInst;
        String fisheyeInstStr;
        File apphome;
        if (args.length == 0) {
            System.err.println("At least one argument required.");
            FishEyeCtl.usage();
            return 1;
        }
        List<String> arglist = Arrays.asList(args);
        String apphomeStr = System.getProperty("fisheye.home");
        if (apphomeStr == null) {
            apphome = FishEyeCtl.findAppHome();
            System.setProperty("fisheye.home", apphome.getPath());
        } else {
            apphome = new File(apphomeStr);
        }
        if (!apphome.isDirectory()) {
            System.err.println("WARN: fisheye.home is not a directory (or not found): " + apphome.getAbsolutePath());
        }
        if ((fisheyeInstStr = System.getProperty("fisheye.inst")) != null) {
            fisheyeInst = new File(fisheyeInstStr);
            if (!fisheyeInst.isDirectory()) {
                System.err.println("WARN: fisheye.inst is not a directory (or not found): " + fisheyeInst.getAbsolutePath());
            }
        } else {
            fisheyeInst = null;
        }
        try {
            env = FishEyeCtl.makeClassLoader(apphome, fisheyeInst);
        }
        catch (MalformedURLException e) {
            System.err.println("ERROR: problem loading jar: " + e.getMessage());
            e.printStackTrace();
            return 1;
        }
        CLASSLOADER = env;
        Thread.currentThread().setContextClassLoader(env);
        String cmd = args[0];
        String mainClassName = (String)COMMANDS.get(cmd);
        if (mainClassName == null) {
            System.err.println("Unknown command: " + cmd);
            FishEyeCtl.usage();
            return 1;
        }
        String[] nextargs = arglist.subList(1, arglist.size()).toArray(STRING_ARRAY);
        try {
            Class<?> clazz = env.loadClass(mainClassName);
            Method method = clazz.getMethod("main", STRING_ARRAY.getClass());
            method.invoke(null, new Object[]{nextargs});
        }
        catch (InvocationTargetException e) {
            System.err.println("ERROR: problem running command");
            e.printStackTrace();
            return 1;
        }
        catch (Throwable e) {
            System.err.println("ERROR: problem invoking main class: " + mainClassName);
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    private static void usage() {
        System.err.println("Usage:");
        System.err.println(" fisheyectl COMMAND [options]");
        System.err.println("");
        System.err.println("Valid COMMANDs are:");
        System.err.println("");
        System.err.println(" run                           run FishEye");
        System.err.println(" start                         start FishEye (in the background)");
        System.err.println(" stop                          stop a running instance");
        System.err.println(" fullscan [repname ...]        perform a fullscan over one or more repositories");
        System.err.println(" rescan repname start end      perform a rescan over repository revisions");
        System.err.println(" reindex [repname ...]         perform a full reindex of one or more repositories");
        System.err.println(" backup [filename]             performs a backup of system configuration");
        System.err.println(" scannow [-s] [repname ...]    performs a single scan of one or more repositories\n                               Specify -s for synchronous operation");
    }

    private static FishEyeClassLoader makeClassLoader(File apphome, File fisheyeInst) throws MalformedURLException {
        File instLibdir;
        File libdir;
        ClassLoader parent = FishEyeCtl.class.getClassLoader();
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        if (!(libdir = new File(apphome, "lib")).isDirectory()) {
            System.err.println("ERROR: lib is not a directory (or not found): " + libdir.getAbsolutePath());
            System.exit(1);
        }
        FishEyeClassLoader cl = new FishEyeClassLoader(parent);
        cl.addJar(new File(apphome, "fisheye.jar"));
        FishEyeCtl.addToolsJar(cl);
        cl.addJarsFromDir(libdir);
        if (fisheyeInst != null && !fisheyeInst.equals(apphome) && (instLibdir = new File(fisheyeInst, "lib")).isDirectory()) {
            cl.addJarsFromDir(instLibdir);
        }
        return cl;
    }

    private static void addToolsJar(FishEyeClassLoader cl) throws MalformedURLException {
        File javaHome = new File(System.getProperty("java.home"));
        File tools = new File(javaHome, "lib/tools.jar");
        if (tools.isFile()) {
            cl.addJar(tools);
        }
        if ((tools = new File(javaHome, "../lib/tools.jar")).isFile()) {
            cl.addJar(tools);
        }
    }

    private static File findAppHome() {
        File bootjar = FishEyeCtl.getBootJarPath();
        if (bootjar.getName().endsWith(".jar")) {
            return bootjar.getParentFile();
        }
        return new File(".");
    }

    private static File getBootJarPath() {
        String pathToClass = "/" + FishEyeCtl.class.getName().replace('.', '/') + ".class";
        URL url = FishEyeCtl.class.getResource(pathToClass);
        if (url != null) {
            String path = url.toString();
            if (path.startsWith("jar:file:")) {
                int bang = path.indexOf("!");
                return new File(FileUtils.fromURI(path.substring(4, bang))).getAbsoluteFile();
            }
            if (path.startsWith("file:")) {
                int tail = path.indexOf(pathToClass);
                return new File(FileUtils.fromURI(path.substring(0, tail))).getAbsoluteFile();
            }
        }
        return null;
    }

    static {
        COMMANDS.put("run", "com.cenqua.fisheye.ctl.Run");
        COMMANDS.put("start", "com.cenqua.fisheye.ctl.Run");
        COMMANDS.put("stop", "com.cenqua.fisheye.ctl.Stop");
        COMMANDS.put("fullscan", "com.cenqua.fisheye.ctl.Fullscan");
        COMMANDS.put("loadsvndump", "com.cenqua.fisheye.ctl.LoadSvnDump");
        COMMANDS.put("backup", "com.cenqua.fisheye.ctl.Backup");
        COMMANDS.put("rescan", "com.cenqua.fisheye.ctl.Rescan");
        COMMANDS.put("scannow", "com.cenqua.fisheye.ctl.ScanNow");
        COMMANDS.put("reindex", "com.cenqua.fisheye.ctl.Reindex");
    }
}

