/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.OutputStream;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;

public class SVNCancellableEditor
implements ISVNEditor {
    private ISVNEditor myDelegate;
    private ISVNEventHandler myCancel;
    private ISVNDebugLog myLog;

    public static ISVNEditor newInstance(ISVNEditor editor, ISVNEventHandler cancel, ISVNDebugLog log) {
        if (cancel != null) {
            return new SVNCancellableEditor(editor, cancel, log);
        }
        return editor;
    }

    private SVNCancellableEditor(ISVNEditor delegate, ISVNEventHandler cancel, ISVNDebugLog log) {
        this.myDelegate = delegate;
        this.myCancel = cancel;
        this.myLog = log == null ? SVNDebugLog.getDefaultLog() : log;
    }

    public void targetRevision(long revision) throws SVNException {
        this.myCancel.checkCancelled();
        this.myDelegate.targetRevision(revision);
    }

    public void openRoot(long revision) throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.info("root");
        this.myDelegate.openRoot(revision);
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.info("del " + path);
        this.myDelegate.deleteEntry(path, revision);
    }

    public void absentDir(String path) throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.info("absent dir " + path);
        this.myDelegate.absentDir(path);
    }

    public void absentFile(String path) throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.info("absent file " + path);
        this.myDelegate.absentFile(path);
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.info("add dir " + path);
        this.myDelegate.addDir(path, copyFromPath, copyFromRevision);
    }

    public void openDir(String path, long revision) throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.info("open dir " + path);
        this.myDelegate.openDir(path, revision);
    }

    public void changeDirProperty(String name, String value) throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.info("change dir prop " + name + " = " + value);
        this.myDelegate.changeDirProperty(name, value);
    }

    public void closeDir() throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.info("close dir");
        this.myDelegate.closeDir();
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.info("add file " + path);
        this.myDelegate.addFile(path, copyFromPath, copyFromRevision);
    }

    public void openFile(String path, long revision) throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.info("open file " + path);
        this.myDelegate.openFile(path, revision);
    }

    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.info("apply delta " + path);
        this.myDelegate.applyTextDelta(path, baseChecksum);
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        this.myLog.info("delta chunk " + path);
        return this.myDelegate.textDeltaChunk(path, diffWindow);
    }

    public void textDeltaEnd(String path) throws SVNException {
        this.myLog.info("delta end " + path);
        this.myDelegate.textDeltaEnd(path);
    }

    public void changeFileProperty(String path, String name, String value) throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.info("change file prop " + name + " = " + value);
        this.myDelegate.changeFileProperty(path, name, value);
    }

    public void closeFile(String path, String textChecksum) throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.info("close file " + path);
        this.myDelegate.closeFile(path, textChecksum);
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        this.myCancel.checkCancelled();
        this.myLog.info("close edit");
        return this.myDelegate.closeEdit();
    }

    public void abortEdit() throws SVNException {
        this.myLog.info("abort edit");
        this.myDelegate.abortEdit();
    }
}

