/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.user;

import com.atlassian.core.user.UserUtils;
import com.opensymphony.user.DuplicateEntityException;
import com.opensymphony.user.EntityNotFoundException;
import com.opensymphony.user.Group;
import com.opensymphony.user.ImmutableException;
import com.opensymphony.user.User;
import com.opensymphony.user.UserManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Category;

public class GroupUtils {
    private static final Category log = Category.getInstance((Class)GroupUtils.class);
    static final Comparator alphaGroupComparator = new Comparator(){

        public int compare(Object a, Object b) {
            if (a == null) {
                if (b == null) {
                    return 0;
                }
                return -1;
            }
            if (b == null) {
                return 1;
            }
            return alphaStringComparator.compare(((Group)a).getName(), ((Group)b).getName());
        }
    };
    static final Comparator alphaStringComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            String a = (String)o1;
            String b = (String)o2;
            if (a == null) {
                if (b == null) {
                    return 0;
                }
                return -1;
            }
            if (b == null) {
                return 1;
            }
            return a.compareToIgnoreCase(b);
        }
    };

    public static Group getGroupSafely(String name) throws ImmutableException {
        Group group = null;
        try {
            group = UserManager.getInstance().getGroup(name);
        }
        catch (EntityNotFoundException e) {
            try {
                group = UserManager.getInstance().createGroup(name);
            }
            catch (DuplicateEntityException e1) {
                e.printStackTrace(System.err);
            }
        }
        return group;
    }

    public static Group getGroup(String name) {
        if (name == null) {
            return null;
        }
        if (GroupUtils.existsGroup(name)) {
            try {
                return UserManager.getInstance().getGroup(name);
            }
            catch (EntityNotFoundException e) {
                log.error((Object)("Error getting group: " + name), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static boolean existsGroup(String name) {
        try {
            UserManager.getInstance().getGroup(name);
        }
        catch (EntityNotFoundException e) {
            return false;
        }
        return true;
    }

    public static Collection getGroups() {
        List groups = UserManager.getInstance().getGroups();
        GroupUtils.sortGroups(groups);
        return groups;
    }

    public static void sortGroups(List groups) {
        Collections.sort(groups, alphaGroupComparator);
    }

    public static void sortGroupNames(List groups) {
        Collections.sort(groups, alphaStringComparator);
    }

    public static void removeGroup(Group group) throws Exception {
        HashSet users = new HashSet(group.getUsers());
        Iterator iterator = users.iterator();
        while (iterator.hasNext()) {
            try {
                User u = UserUtils.getUser((String)iterator.next());
                u.removeFromGroup(group);
            }
            catch (EntityNotFoundException entityNotFoundException) {}
        }
        group.remove();
    }
}

