/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.chart.labels;

import clover.org.jfree.chart.labels.XYItemLabelGenerator;
import clover.org.jfree.chart.labels.XYToolTipGenerator;
import clover.org.jfree.data.time.RegularTimePeriod;
import clover.org.jfree.data.time.TimeSeriesCollection;
import clover.org.jfree.data.xy.XYDataset;
import clover.org.jfree.data.xy.XisSymbolic;
import clover.org.jfree.data.xy.YisSymbolic;
import clover.org.jfree.util.PublicCloneable;
import java.io.Serializable;

public class SymbolicXYItemLabelGenerator
implements XYItemLabelGenerator,
XYToolTipGenerator,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 3963400354475494395L;

    /*
     * WARNING - void declaration
     */
    public String generateToolTip(XYDataset data, int series, int item) {
        void xStr;
        String string;
        double d;
        String string2;
        if (data instanceof YisSymbolic) {
            string2 = ((YisSymbolic)((Object)data)).getYSymbolicValue(series, item);
        } else {
            d = data.getYValue(series, item);
            string2 = Double.toString(SymbolicXYItemLabelGenerator.round(d, 2));
        }
        if (data instanceof XisSymbolic) {
            string = ((XisSymbolic)((Object)data)).getXSymbolicValue(series, item);
        } else if (data instanceof TimeSeriesCollection) {
            RegularTimePeriod regularTimePeriod = ((TimeSeriesCollection)data).getSeries(series).getTimePeriod(item);
            string = regularTimePeriod.toString();
        } else {
            d = data.getXValue(series, item);
            string = Double.toString(SymbolicXYItemLabelGenerator.round(d, 2));
        }
        return "X: " + string + ", Y: " + (String)xStr;
    }

    public String generateLabel(XYDataset dataset, int series, int category) {
        return null;
    }

    private static double round(double value, int nb) {
        if (nb <= 0) {
            return Math.floor(value + 0.5);
        }
        double p = Math.pow(10.0, nb);
        double tempval = Math.floor(value * p + 0.5);
        return tempval / p;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof SymbolicXYItemLabelGenerator;
    }
}

