/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.chart.renderer.category;

import clover.org.jfree.chart.axis.CategoryAxis;
import clover.org.jfree.chart.axis.ValueAxis;
import clover.org.jfree.chart.entity.CategoryItemEntity;
import clover.org.jfree.chart.entity.EntityCollection;
import clover.org.jfree.chart.labels.CategoryItemLabelGenerator;
import clover.org.jfree.chart.labels.CategoryToolTipGenerator;
import clover.org.jfree.chart.plot.CategoryPlot;
import clover.org.jfree.chart.plot.PlotOrientation;
import clover.org.jfree.chart.renderer.category.CategoryItemRendererState;
import clover.org.jfree.chart.renderer.category.IntervalBarRenderer;
import clover.org.jfree.data.category.CategoryDataset;
import clover.org.jfree.data.gantt.GanttCategoryDataset;
import clover.org.jfree.io.SerialUtilities;
import clover.org.jfree.ui.RectangleEdge;
import clover.org.jfree.util.PaintUtilities;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class GanttRenderer
extends IntervalBarRenderer
implements Serializable {
    private static final long serialVersionUID = -4010349116350119512L;
    private transient Paint completePaint;
    private transient Paint incompletePaint;
    private double startPercent;
    private double endPercent;

    public GanttRenderer() {
        this.setIncludeBaseInRange(false);
        this.completePaint = Color.green;
        this.incompletePaint = Color.red;
        this.startPercent = 0.35;
        this.endPercent = 0.65;
    }

    public Paint getCompletePaint() {
        return this.completePaint;
    }

    public void setCompletePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.completePaint = paint;
        this.fireChangeEvent();
    }

    public Paint getIncompletePaint() {
        return this.incompletePaint;
    }

    public void setIncompletePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.incompletePaint = paint;
        this.fireChangeEvent();
    }

    public double getStartPercent() {
        return this.startPercent;
    }

    public void setStartPercent(double percent) {
        this.startPercent = percent;
        this.fireChangeEvent();
    }

    public double getEndPercent() {
        return this.endPercent;
    }

    public void setEndPercent(double percent) {
        this.endPercent = percent;
        this.fireChangeEvent();
    }

    public void drawItem(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset dataset, int row, int column, int pass) {
        if (dataset instanceof GanttCategoryDataset) {
            GanttCategoryDataset gcd = (GanttCategoryDataset)dataset;
            this.drawTasks(g2, state, dataArea, plot, domainAxis, rangeAxis, gcd, row, column);
        } else {
            super.drawItem(g2, state, dataArea, plot, domainAxis, rangeAxis, dataset, row, column, pass);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void drawTasks(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, GanttCategoryDataset dataset, int row, int column) {
        int count = dataset.getSubIntervalCount(row, column);
        if (count == 0) {
            this.drawTask(g2, state, dataArea, plot, domainAxis, rangeAxis, dataset, row, column);
        }
        for (int subinterval = 0; subinterval < count; ++subinterval) {
            void url;
            EntityCollection entityCollection;
            RectangleEdge rangeAxisLocation = plot.getRangeAxisEdge();
            Number value0 = dataset.getStartValue(row, column, subinterval);
            if (value0 == null) {
                return;
            }
            double translatedValue0 = rangeAxis.valueToJava2D(value0.doubleValue(), dataArea, rangeAxisLocation);
            Number value1 = dataset.getEndValue(row, column, subinterval);
            if (value1 == null) {
                return;
            }
            double translatedValue1 = rangeAxis.valueToJava2D(value1.doubleValue(), dataArea, rangeAxisLocation);
            if (translatedValue1 < translatedValue0) {
                double temp = translatedValue1;
                translatedValue1 = translatedValue0;
                translatedValue0 = temp;
            }
            double rectStart = this.calculateBarW0(plot, plot.getOrientation(), dataArea, domainAxis, state, row, column);
            double rectLength = Math.abs(translatedValue1 - translatedValue0);
            double rectBreadth = state.getBarWidth();
            Rectangle2D.Double bar = null;
            if (plot.getOrientation() == PlotOrientation.HORIZONTAL) {
                bar = new Rectangle2D.Double(translatedValue0, rectStart, rectLength, rectBreadth);
            } else if (plot.getOrientation() == PlotOrientation.VERTICAL) {
                bar = new Rectangle2D.Double(rectStart, translatedValue0, rectBreadth, rectLength);
            }
            Rectangle2D.Double completeBar = null;
            Rectangle2D.Double incompleteBar = null;
            Number percent = dataset.getPercentComplete(row, column, subinterval);
            double start = this.getStartPercent();
            double end = this.getEndPercent();
            if (percent != null) {
                double p = percent.doubleValue();
                if (plot.getOrientation() == PlotOrientation.HORIZONTAL) {
                    completeBar = new Rectangle2D.Double(translatedValue0, rectStart + start * rectBreadth, rectLength * p, rectBreadth * (end - start));
                    incompleteBar = new Rectangle2D.Double(translatedValue0 + rectLength * p, rectStart + start * rectBreadth, rectLength * (1.0 - p), rectBreadth * (end - start));
                } else if (plot.getOrientation() == PlotOrientation.VERTICAL) {
                    completeBar = new Rectangle2D.Double(rectStart + start * rectBreadth, translatedValue0 + rectLength * (1.0 - p), rectBreadth * (end - start), rectLength * p);
                    incompleteBar = new Rectangle2D.Double(rectStart + start * rectBreadth, translatedValue0, rectBreadth * (end - start), rectLength * (1.0 - p));
                }
            }
            Paint paint = this.getItemPaint(row, column);
            g2.setPaint(paint);
            g2.fill(bar);
            if (completeBar != null) {
                g2.setPaint(this.getCompletePaint());
                g2.fill(completeBar);
            }
            if (incompleteBar != null) {
                g2.setPaint(this.getIncompletePaint());
                g2.fill(incompleteBar);
            }
            if (this.isDrawBarOutline() && state.getBarWidth() > 3.0) {
                g2.setStroke(this.getItemStroke(row, column));
                g2.setPaint(this.getItemOutlinePaint(row, column));
                g2.draw(bar);
            }
            if (state.getInfo() == null || (entityCollection = state.getEntityCollection()) == null) continue;
            String string = null;
            if (this.getToolTipGenerator(row, column) != null) {
                string = this.getToolTipGenerator(row, column).generateToolTip(dataset, row, column);
            }
            String string2 = null;
            if (this.getItemURLGenerator(row, column) != null) {
                string2 = this.getItemURLGenerator(row, column).generateURL(dataset, row, column);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(bar, string, string2, dataset, dataset.getRowKey(row), dataset.getColumnKey(column));
            url.add(categoryItemEntity);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void drawTask(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, GanttCategoryDataset dataset, int row, int column) {
        Object object;
        Object object2;
        void completeBar;
        Rectangle2D.Double percent;
        Rectangle2D.Double incompleteBar;
        PlotOrientation orientation = plot.getOrientation();
        RectangleEdge rangeAxisLocation = plot.getRangeAxisEdge();
        Number value0 = dataset.getEndValue(row, column);
        if (value0 == null) {
            return;
        }
        double java2dValue0 = rangeAxis.valueToJava2D(value0.doubleValue(), dataArea, rangeAxisLocation);
        Number value1 = dataset.getStartValue(row, column);
        if (value1 == null) {
            return;
        }
        double java2dValue1 = rangeAxis.valueToJava2D(value1.doubleValue(), dataArea, rangeAxisLocation);
        if (java2dValue1 < java2dValue0) {
            double temp = java2dValue1;
            java2dValue1 = java2dValue0;
            java2dValue0 = temp;
            Number tempNum = value1;
            value1 = value0;
            value0 = tempNum;
        }
        double rectStart = this.calculateBarW0(plot, orientation, dataArea, domainAxis, state, row, column);
        double d = state.getBarWidth();
        double d2 = Math.abs(java2dValue1 - java2dValue0);
        Rectangle2D.Double double_ = null;
        if (orientation == PlotOrientation.HORIZONTAL) {
            double_ = new Rectangle2D.Double(java2dValue0, rectStart, d2, d);
        } else if (orientation == PlotOrientation.VERTICAL) {
            double_ = new Rectangle2D.Double(rectStart, java2dValue1, d, d2);
        }
        Object var26_21 = null;
        Object var27_22 = null;
        Number number = dataset.getPercentComplete(row, column);
        double d3 = this.getStartPercent();
        double d4 = this.getEndPercent();
        if (number != null) {
            double d5 = number.doubleValue();
            if (plot.getOrientation() == PlotOrientation.HORIZONTAL) {
                incompleteBar = new Rectangle2D.Double(java2dValue0, rectStart + d3 * d, d2 * d5, d * (d4 - d3));
                percent = new Rectangle2D.Double(java2dValue0 + d2 * d5, rectStart + d3 * d, d2 * (1.0 - d5), d * (d4 - d3));
            } else if (plot.getOrientation() == PlotOrientation.VERTICAL) {
                incompleteBar = new Rectangle2D.Double(rectStart + d3 * d, java2dValue1 + d2 * (1.0 - d5), d * (d4 - d3), d2 * d5);
                percent = new Rectangle2D.Double(rectStart + d3 * d, java2dValue1, d * (d4 - d3), d2 * (1.0 - d5));
            }
        }
        Paint paint = this.getItemPaint(row, column);
        g2.setPaint(paint);
        g2.fill((Shape)completeBar);
        if (incompleteBar != null) {
            g2.setPaint(this.getCompletePaint());
            g2.fill(incompleteBar);
        }
        if (percent != null) {
            g2.setPaint(this.getIncompletePaint());
            g2.fill(percent);
        }
        if (this.isDrawBarOutline() && state.getBarWidth() > 3.0) {
            object2 = this.getItemOutlineStroke(row, column);
            object = this.getItemOutlinePaint(row, column);
            if (object2 != null && object != null) {
                g2.setStroke((Stroke)object2);
                g2.setPaint((Paint)object);
                g2.draw((Shape)completeBar);
            }
        }
        if ((object2 = this.getItemLabelGenerator(row, column)) != null && this.isItemLabelVisible(row, column)) {
            this.drawItemLabel(g2, dataset, row, column, plot, (CategoryItemLabelGenerator)object2, (Rectangle2D)completeBar, false);
        }
        if (state.getInfo() != null && (object = state.getEntityCollection()) != null) {
            void url;
            String string = null;
            CategoryToolTipGenerator categoryToolTipGenerator = this.getToolTipGenerator(row, column);
            if (categoryToolTipGenerator != null) {
                string = categoryToolTipGenerator.generateToolTip(dataset, row, column);
            }
            String string2 = null;
            if (this.getItemURLGenerator(row, column) != null) {
                string2 = this.getItemURLGenerator(row, column).generateURL(dataset, row, column);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity((Shape)completeBar, string, string2, dataset, dataset.getRowKey(row), dataset.getColumnKey(column));
            url.add(categoryItemEntity);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GanttRenderer)) {
            return false;
        }
        GanttRenderer that = (GanttRenderer)obj;
        if (!PaintUtilities.equal(this.completePaint, that.completePaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.incompletePaint, that.incompletePaint)) {
            return false;
        }
        if (this.startPercent != that.startPercent) {
            return false;
        }
        if (this.endPercent != that.endPercent) {
            return false;
        }
        return super.equals(obj);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaint(this.completePaint, stream);
        SerialUtilities.writePaint(this.incompletePaint, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.completePaint = SerialUtilities.readPaint(stream);
        this.incompletePaint = SerialUtilities.readPaint(stream);
    }
}

