/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.data.statistics;

import clover.org.jfree.data.statistics.BoxAndWhiskerItem;
import clover.org.jfree.data.statistics.Statistics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class BoxAndWhiskerCalculator {
    public static BoxAndWhiskerItem calculateBoxAndWhiskerStatistics(List values) {
        return BoxAndWhiskerCalculator.calculateBoxAndWhiskerStatistics(values, true);
    }

    public static BoxAndWhiskerItem calculateBoxAndWhiskerStatistics(List values, boolean stripNullAndNaNItems) {
        ArrayList<Number> vlist;
        if (values == null) {
            throw new IllegalArgumentException("Null 'values' argument.");
        }
        if (stripNullAndNaNItems) {
            vlist = new ArrayList<Number>(values.size());
            ListIterator iterator = values.listIterator();
            while (iterator.hasNext()) {
                Number n;
                double v;
                Object obj = iterator.next();
                if (!(obj instanceof Number) || Double.isNaN(v = (n = (Number)obj).doubleValue())) continue;
                vlist.add(n);
            }
        } else {
            vlist = values;
        }
        Collections.sort(vlist);
        double d = Statistics.calculateMean(vlist, false);
        double d2 = Statistics.calculateMedian(vlist, false);
        double d3 = BoxAndWhiskerCalculator.calculateQ1(vlist);
        double d4 = BoxAndWhiskerCalculator.calculateQ3(vlist);
        double d5 = d4 - d3;
        double d6 = d4 + d5 * 1.5;
        double d7 = d3 - d5 * 1.5;
        double d8 = d4 + d5 * 2.0;
        double d9 = d3 - d5 * 2.0;
        double d10 = Double.POSITIVE_INFINITY;
        double d11 = Double.NEGATIVE_INFINITY;
        double d12 = Double.POSITIVE_INFINITY;
        double d13 = Double.NEGATIVE_INFINITY;
        ArrayList<Number> arrayList = new ArrayList<Number>();
        Iterator iterator = vlist.iterator();
        while (iterator.hasNext()) {
            double value;
            Number number = (Number)iterator.next();
            double d14 = number.doubleValue();
            if (d14 > d6) {
                arrayList.add(number);
                if (d14 > value && d14 <= d8) {
                    value = d14;
                }
            } else if (d14 < d7) {
                arrayList.add(number);
                if (d14 < d12 && d14 >= d9) {
                    d12 = d14;
                }
            } else {
                d10 = Math.min(d10, d14);
                d11 = Math.max(d11, d14);
            }
            d12 = Math.min(d12, d10);
            value = Math.max(value, d11);
        }
        return new BoxAndWhiskerItem(new Double(d), new Double(d2), new Double(d3), new Double(d4), new Double(d10), new Double(d11), new Double(d12), new Double(d13), (List)arrayList);
    }

    public static double calculateQ1(List values) {
        if (values == null) {
            throw new IllegalArgumentException("Null 'values' argument.");
        }
        double result = Double.NaN;
        int count = values.size();
        if (count > 0) {
            result = count % 2 == 1 ? (count > 1 ? Statistics.calculateMedian(values, 0, count / 2) : Statistics.calculateMedian(values, 0, 0)) : Statistics.calculateMedian(values, 0, count / 2 - 1);
        }
        return result;
    }

    public static double calculateQ3(List values) {
        if (values == null) {
            throw new IllegalArgumentException("Null 'values' argument.");
        }
        double result = Double.NaN;
        int count = values.size();
        if (count > 0) {
            result = count % 2 == 1 ? (count > 1 ? Statistics.calculateMedian(values, count / 2, count - 1) : Statistics.calculateMedian(values, 0, 0)) : Statistics.calculateMedian(values, count / 2, count - 1);
        }
        return result;
    }
}

