/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.threads;

import java.util.ArrayList;
import java.util.Iterator;

public class ReaderWriterLock {
    private ArrayList waiters = new ArrayList();

    /*
     * WARNING - void declaration
     */
    public synchronized void lockRead() {
        void node;
        ReaderWriterNode index;
        Thread thread = Thread.currentThread();
        int me = this.getIndex(thread);
        if (me == -1) {
            index = new ReaderWriterNode(thread, 0);
            this.waiters.add(index);
        } else {
            index = (ReaderWriterNode)this.waiters.get(me);
        }
        while (this.getIndex((Thread)node) > this.firstWriter()) {
            try {
                this.wait();
            }
            catch (Exception e) {
                System.err.println("ReaderWriterLock.lockRead(): exception.");
                System.err.print(e.getMessage());
            }
        }
        ++index.nAcquires;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void lockWrite() {
        void node;
        ReaderWriterNode index;
        Thread thread = Thread.currentThread();
        int me = this.getIndex(thread);
        if (me == -1) {
            index = new ReaderWriterNode(thread, 1);
            this.waiters.add(index);
        } else {
            index = (ReaderWriterNode)this.waiters.get(me);
            if (index.state == 0) {
                throw new IllegalArgumentException("Upgrade lock");
            }
            index.state = 1;
        }
        while (this.getIndex((Thread)node) != 0) {
            try {
                this.wait();
            }
            catch (Exception e) {
                System.err.println("ReaderWriterLock.lockWrite(): exception.");
                System.err.print(e.getMessage());
            }
        }
        ++index.nAcquires;
    }

    public synchronized void unlock() {
        Thread thread = Thread.currentThread();
        int me = this.getIndex(thread);
        if (me > this.firstWriter()) {
            throw new IllegalArgumentException("Lock not held");
        }
        ReaderWriterNode index = (ReaderWriterNode)this.waiters.get(me);
        --index.nAcquires;
        if (index.nAcquires == 0) {
            this.waiters.remove(me);
        }
        this.notifyAll();
    }

    private int firstWriter() {
        Iterator e = this.waiters.iterator();
        int index = 0;
        while (e.hasNext()) {
            ReaderWriterNode node = (ReaderWriterNode)e.next();
            if (node.state == 1) {
                return index;
            }
            ++index;
        }
        return Integer.MAX_VALUE;
    }

    private int getIndex(Thread t) {
        Iterator e = this.waiters.iterator();
        int index = 0;
        while (e.hasNext()) {
            ReaderWriterNode node = (ReaderWriterNode)e.next();
            if (node.t == t) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private static class ReaderWriterNode {
        protected static final int READER = 0;
        protected static final int WRITER = 1;
        protected Thread t;
        protected int state;
        protected int nAcquires;

        private ReaderWriterNode(Thread t, int state) {
            this.t = t;
            this.state = state;
            this.nAcquires = 0;
        }
    }
}

