/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.context.NamedContext;
import com.cenqua.clover.registry.BaseFileInfo;
import com.cenqua.clover.registry.CoverageDataProvider;
import com.cenqua.clover.registry.CoverageDataReceptor;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.SourceRegion;
import java.io.Serializable;

public abstract class ElementInfo
extends SourceRegion
implements CoverageDataReceptor,
Serializable {
    private ContextSet context;
    private int relativeDataIndex;
    private int dataLength = 1;
    private int complexity;
    protected transient CoverageDataProvider data;
    private static final long serialVersionUID = -7840416866839728022L;

    public ElementInfo(BaseFileInfo containingFile, int relativeDataIndex, ContextSet context, SourceRegion region, int complexity) {
        super(containingFile, region);
        this.relativeDataIndex = relativeDataIndex;
        this.context = context;
        this.complexity = complexity;
    }

    public ContextSet getContext() {
        return this.context;
    }

    public void setContext(ContextSet context) {
        this.context = context;
    }

    public boolean isFiltered(ContextSet filter) {
        return filter != null && filter.intersects(this.context);
    }

    public void addContext(NamedContext ctx) {
        this.context.set(ctx.getIndex());
    }

    public int getComplexity() {
        return this.complexity;
    }

    public void setComplexity(int complexity) {
        this.complexity = complexity;
    }

    public int getHitCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.getCoverage(this.getDataIndex());
    }

    public void setDataProvider(CoverageDataProvider data) {
        this.data = data;
    }

    public CoverageDataProvider getDataProvider() {
        return this.data;
    }

    public int getRelativeDataIndex() {
        return this.relativeDataIndex;
    }

    public int getDataIndex() {
        return ((FileInfo)this.containingFile).dataIndex + this.relativeDataIndex;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int length) {
        this.dataLength = length;
    }
}

