/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.instr.MethodSignature;
import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.BranchInfo;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.CoverageDataProvider;
import com.cenqua.clover.registry.ElementInfo;
import com.cenqua.clover.registry.FileElementVisitor;
import com.cenqua.clover.registry.HasMetricsNode;
import com.cenqua.clover.registry.SourceRegion;
import com.cenqua.clover.registry.StatementInfo;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MethodInfo
extends ElementInfo
implements HasMetricsNode {
    private static final long serialVersionUID = -4931223303157425990L;
    private MethodSignature signature;
    private ClassInfo containingClass;
    private boolean test = false;
    private List statements = new ArrayList();
    private List branches = new ArrayList();
    private transient String name;
    private transient BlockMetrics rawMetrics;
    private transient BlockMetrics metrics;
    private transient ContextSet contextFilter;

    public MethodInfo(ClassInfo containingClass, int relativeDataIndex, ContextSet context, SourceRegion region, MethodSignature signature, boolean test) {
        super(containingClass.getContainingFile(), relativeDataIndex, context, region, 1);
        this.signature = signature;
        this.containingClass = containingClass;
        this.test = test;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.signature.getName() + "(" + this.listParamTypes() + ")" + (this.signature.getReturnType() != null ? " : " + this.signature.getReturnType() : "");
        }
        return this.name;
    }

    public String getSimpleName() {
        return this.signature.getName();
    }

    private String listParamTypes() {
        StringBuffer types = new StringBuffer();
        String sep = "";
        for (int i = 0; this.signature.getParamTypes() != null && i < this.signature.getParamTypes().length; ++i) {
            types.append(sep);
            types.append(this.signature.getParamTypes()[i]);
            sep = ",";
        }
        return types.toString();
    }

    public MethodSignature getSignature() {
        return this.signature;
    }

    public String getQualifiedName() {
        return this.containingClass.getQualifiedName() + "." + this.signature.getName();
    }

    public ClassInfo getContainingClass() {
        return this.containingClass;
    }

    public boolean isTest() {
        return this.test;
    }

    public boolean isEmpty() {
        return this.statements.size() == 0 && this.branches.size() == 0;
    }

    public StatementInfo[] getStatements() {
        return this.statements.toArray(new StatementInfo[this.statements.size()]);
    }

    public BranchInfo[] getBranches() {
        return this.branches.toArray(new BranchInfo[this.branches.size()]);
    }

    public BlockMetrics getMetrics() {
        if (this.metrics == null || this.getContainingClass().getContextFilter() != this.contextFilter) {
            this.contextFilter = this.getContainingClass().getContextFilter();
            this.metrics = this.calcMetrics(this.contextFilter);
        }
        return this.metrics;
    }

    public BlockMetrics getRawMetrics() {
        if (this.rawMetrics == null) {
            this.rawMetrics = this.calcMetrics(null);
        }
        return this.rawMetrics;
    }

    public void setMetrics(BlockMetrics metrics) {
        this.metrics = metrics;
    }

    void addStatement(StatementInfo stmt) {
        this.statements.add(stmt);
    }

    void addBranch(BranchInfo branch) {
        this.branches.add(branch);
    }

    public void setDataProvider(CoverageDataProvider data) {
        super.setDataProvider(data);
        Iterator stmts = this.statements.iterator();
        while (stmts.hasNext()) {
            StatementInfo statementInfo = (StatementInfo)stmts.next();
            statementInfo.setDataProvider(data);
        }
        Iterator iterator = this.branches.iterator();
        while (iterator.hasNext()) {
            BranchInfo branchInfo = (BranchInfo)iterator.next();
            branchInfo.setDataProvider(data);
        }
        this.rawMetrics = null;
        this.metrics = null;
    }

    public void gatherSourceRegions(Set regions) {
        regions.add(this);
        regions.addAll(this.statements);
        regions.addAll(this.branches);
    }

    public void visit(FileElementVisitor visitor) {
        visitor.visitMethod(this);
        Iterator stmts = this.statements.iterator();
        while (stmts.hasNext()) {
            StatementInfo statementInfo = (StatementInfo)stmts.next();
            visitor.visitStatement(statementInfo);
        }
        Iterator it = this.branches.iterator();
        while (it.hasNext()) {
            BranchInfo branchInfo = (BranchInfo)it.next();
            visitor.visitBranch(branchInfo);
        }
    }

    public boolean isLeaf() {
        return true;
    }

    public int getNumChildren() {
        return 0;
    }

    public String getChildType() {
        return null;
    }

    public HasMetricsNode getChild(int i) {
        return null;
    }

    public int getIndexOfChild(HasMetricsNode child) {
        return -1;
    }

    public void setComparator(Comparator cmp) {
    }

    private BlockMetrics calcMetrics(ContextSet contextSet) {
        BlockMetrics blockMetrics = new BlockMetrics(this);
        int covered = 0;
        int numStatements = 0;
        int numBranches = 0;
        int complexity = 1;
        Iterator stmts = this.statements.iterator();
        while (stmts.hasNext()) {
            StatementInfo statementInfo = (StatementInfo)stmts.next();
            if (statementInfo.isFiltered(contextSet)) continue;
            if (statementInfo.getHitCount() > 0) {
                ++covered;
            }
            complexity += statementInfo.getComplexity();
            ++numStatements;
        }
        blockMetrics.setNumCoveredStatements(covered);
        blockMetrics.setNumStatements(numStatements);
        covered = 0;
        Iterator iterator = this.branches.iterator();
        while (iterator.hasNext()) {
            BranchInfo branchInfo = (BranchInfo)iterator.next();
            if (branchInfo.isFiltered(contextSet)) continue;
            if (branchInfo.getTrueHitCount() > 0) {
                ++covered;
            }
            if (branchInfo.getFalseHitCount() > 0) {
                ++covered;
            }
            complexity += branchInfo.getComplexity();
            numBranches += 2;
        }
        blockMetrics.setNumCoveredBranches(covered);
        blockMetrics.setNumBranches(numBranches);
        blockMetrics.setComplexity(complexity);
        this.setComplexity(complexity);
        return blockMetrics;
    }

    public MethodInfo copy(ClassInfo newParent) {
        MethodInfo method = new MethodInfo(newParent, this.getRelativeDataIndex(), this.getContext(), this, this.signature, this.test);
        method.setDataProvider(this.getDataProvider());
        Iterator stmts = this.statements.iterator();
        while (stmts.hasNext()) {
            StatementInfo statementInfo = (StatementInfo)stmts.next();
            method.addStatement(statementInfo.copy(method));
        }
        Iterator iterator = this.branches.iterator();
        while (iterator.hasNext()) {
            BranchInfo branchInfo = (BranchInfo)iterator.next();
            method.addBranch(branchInfo.copy(method));
        }
        method.setDataLength(this.getDataLength());
        return method;
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.signature.getModifiers());
    }

    public int getParamCount() {
        return this.signature.getParamTypes() == null ? 0 : this.signature.getParamTypes().length;
    }
}

