/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters;

import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.CloverException;
import com.cenqua.clover.CoverageDataSpec;
import com.cenqua.clover.cfg.Interval;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.reporters.Columns;
import com.cenqua.clover.reporters.Format;
import com.cenqua.clover.reporters.html.HtmlReporter;
import com.cenqua.clover.util.Path;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class CloverReportConfig {
    private static final String ERR_NO_OUTFILE_SPECIFIED = "No outfile specified.";
    private CloverReportConfig firstCurrentConfig = null;
    private Format format;
    private Columns columns;
    private String title;
    private String homepage;
    private String projectName;
    private String titleAnchor;
    private String titleTarget;
    private String uniqueTitle;
    private File outFile;
    private String mainFileName;
    private boolean needsNewFrame;
    private String initString;
    private Date effectiveDate;
    private Interval span = Interval.ZERO_SECONDS;
    private String invalidReason;
    private boolean alwaysReport = false;
    private boolean compress = false;
    private Path sourcepath;
    private int titleCount = 1;
    private boolean loadTestResults = true;
    private Map linkedReports = new HashMap();
    private HasMetricsFilter includeFilter;
    private HasMetricsFilter.Invertable testFilter;

    public abstract HtmlReporter newReporter() throws IOException, CloverException;

    public void setFirstCurrentConfig(CloverReportConfig currentRoot) {
        this.firstCurrentConfig = currentRoot;
    }

    public CloverReportConfig getFirstCurrentConfig() {
        return this.firstCurrentConfig;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setLinkedReports(Map links) {
        this.linkedReports = links;
    }

    public Map getLinkedReports() {
        return this.linkedReports;
    }

    public String getUniqueTitle() {
        return this.uniqueTitle;
    }

    public void setUniqueTitle(String uniqueTitle) {
        this.uniqueTitle = uniqueTitle;
    }

    public int getTitleCount() {
        return this.titleCount;
    }

    public int incTitleCount() {
        return this.titleCount++;
    }

    public void setInitString(String initString) {
        this.initString = initString;
    }

    public String getInitString() {
        return this.initString;
    }

    public void setOutFile(File outFile) {
        this.outFile = outFile;
        if (outFile != null && outFile.isFile()) {
            this.setMainFileName(outFile.getName());
        }
    }

    public File getOutFile() {
        return this.outFile;
    }

    public String getMainFileName() {
        return this.mainFileName;
    }

    public File getMainOutFile() {
        return this.outFile.isFile() ? this.outFile : new File(this.outFile, this.mainFileName);
    }

    public boolean isNeedsNewFrame() {
        return this.needsNewFrame;
    }

    public void setNeedsNewFrame(boolean needsNewFrame) {
        this.needsNewFrame = needsNewFrame;
    }

    public void setMainFileName(String mainFileName) {
        this.mainFileName = mainFileName;
    }

    public void setAlwaysReport(boolean alwaysReport) {
        this.alwaysReport = alwaysReport;
    }

    public boolean isAlwaysReport() {
        return this.alwaysReport;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public void setSourcepath(Path sourcepath) {
        this.sourcepath = sourcepath;
    }

    public Path getSourcepath() {
        return this.sourcepath;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitleAnchor() {
        return this.titleAnchor;
    }

    public void setTitleAnchor(String titleAnchor) {
        this.titleAnchor = titleAnchor;
    }

    public String getTitleTarget() {
        return this.titleTarget;
    }

    public void setTitleTarget(String titleTarget) {
        this.titleTarget = titleTarget;
    }

    public void setSpan(Interval span) {
        this.span = span;
    }

    private Interval getSpan() {
        return this.span;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public String getTitle() {
        return this.title;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public Format getFormat() {
        return this.format;
    }

    public Columns getColumns() {
        return this.columns != null ? this.columns : this.format.getDefaultColumns();
    }

    public void addColumns(Columns columns) {
        this.columns = columns;
    }

    public boolean isLoadTestResults() {
        return this.loadTestResults;
    }

    public void setLoadTestResults(boolean loadTestResults) {
        this.loadTestResults = loadTestResults;
    }

    public boolean validate() {
        if (this.getOutFile() == null) {
            this.setFailureReason(ERR_NO_OUTFILE_SPECIFIED);
            return false;
        }
        return true;
    }

    public String getValidationFailureReason() {
        return this.invalidReason;
    }

    protected void setFailureReason(String reason) {
        this.invalidReason = reason;
    }

    public CloverDatabase getCoverageDatabase() throws CloverException {
        CloverDatabase db = new CloverDatabase(this.getInitString(), this.includeFilter, this.projectName, this.getFormat().getFilter());
        if (this.getSourcepath() != null) {
            db.resolve(this.getSourcepath());
        }
        CoverageDataSpec spec = new CoverageDataSpec(this.testFilter, this.getSpan().getValueInMillis(), this.loadTestResults);
        spec.setFilterTraces(this.getFormat().isFilterTrace());
        db.loadCoverageData(spec);
        return db;
    }

    public void setIncludeFilter(HasMetricsFilter includeFilter) {
        this.includeFilter = includeFilter;
    }

    public void setTestFilter(HasMetricsFilter.Invertable testFilter) {
        this.testFilter = testFilter;
    }
}

