/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.util;

import com.cenqua.clover.registry.BaseClassInfo;
import java.util.Comparator;

public class CoverageDiffSummary {
    public static final Comparator DIFF_COMP = new Comparator(){

        public int compare(Object aObj1, Object aObj2) {
            float d2;
            if (aObj1 == null && aObj2 == null) {
                return 0;
            }
            if (aObj1 == null) {
                return -1;
            }
            if (aObj2 == null) {
                return 1;
            }
            CoverageDiffSummary ds1 = (CoverageDiffSummary)aObj1;
            CoverageDiffSummary ds2 = (CoverageDiffSummary)aObj2;
            float d1 = ds1.getPcDiff();
            if (d1 == (d2 = ds2.getPcDiff())) {
                return ds1.getName().compareTo(ds2.getName());
            }
            if (d1 > d2) {
                return 1;
            }
            return -1;
        }
    };
    private BaseClassInfo classThen;
    private BaseClassInfo classNow;
    private float pcThen;
    private float pcNow;
    private float diff;

    public CoverageDiffSummary(BaseClassInfo classThen, BaseClassInfo classNow, float pcThen, float pcNow, float diff) {
        this.classThen = classThen;
        this.classNow = classNow;
        this.pcThen = pcThen;
        this.pcNow = pcNow;
        this.diff = diff;
    }

    public float getPcDiff() {
        return this.diff;
    }

    public float getPc1() {
        return this.pcThen;
    }

    public float getPc2() {
        return this.pcNow;
    }

    public BaseClassInfo getCurrentClassInfo() {
        return this.classNow;
    }

    public String getName() {
        return this.classNow.getQualifiedName();
    }

    public String toString() {
        return this.pcThen + " " + this.getName() + " " + this.pcNow + "  (" + (this.diff >= 0.0f ? "+" : "") + this.diff + ")";
    }
}

