/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.xml;

import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.CloverException;
import com.cenqua.clover.CloverStartup;
import com.cenqua.clover.Logger;
import com.cenqua.clover.cfg.Interval;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.BranchInfo;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.ClassMetrics;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.FileMetrics;
import com.cenqua.clover.registry.LineInfo;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.PackageMetrics;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.registry.ProjectMetrics;
import com.cenqua.clover.registry.StatementInfo;
import com.cenqua.clover.reporters.CloverReportConfig;
import com.cenqua.clover.reporters.Current;
import com.cenqua.clover.reporters.Format;
import com.cenqua.clover.reporters.xml.XMLWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public class XMLReporter {
    private CloverDatabase mDb;
    private CloverReportConfig mCfg;
    private ContextSet mContextSet;
    static /* synthetic */ Class class$com$cenqua$clover$reporters$xml$XMLReporter;

    public XMLReporter(CloverDatabase db, CloverReportConfig aCfg) {
        this.mCfg = aCfg;
        this.mDb = db;
        this.mContextSet = this.mDb.getContextSet(this.mCfg.getFormat().getFilter());
    }

    public static int generateReport(CloverDatabase db, CloverReportConfig cfg) throws CloverException {
        try {
            CloverStartup.permsCheck(2L);
            if (!cfg.isAlwaysReport() && db.getNumRecordingsUsed() == 0) {
                Logger.getInstance().warn("No coverage recordings found. No report will be generated.");
                return 1;
            }
            XMLReporter reporter = new XMLReporter(db, cfg);
            Logger.getInstance().debug("constructing report...");
            reporter.doit();
            return 0;
        }
        catch (IOException e) {
            throw new CloverException("IO Exception: " + e.getMessage());
        }
    }

    public static int generateReport(CloverReportConfig cfg) throws CloverException {
        return XMLReporter.generateReport(cfg.getCoverageDatabase(), cfg);
    }

    public static void main(String[] args) {
        System.exit(XMLReporter.mainImpl(args));
    }

    public static int mainImpl(String[] args) {
        CloverStartup.loadLicense(Logger.getInstance());
        CloverReportConfig cfg = XMLReporter.processArgs(args);
        if (cfg != null) {
            try {
                return XMLReporter.generateReport(cfg);
            }
            catch (CloverException e) {
                Logger.getInstance().error("An error occurred while generating the report", e);
            }
        }
        return 1;
    }

    public void doit() throws IOException {
        XMLWriter out = this.initWriter();
        Logger.getInstance().info("Writing report to '" + this.mCfg.getOutFile() + "'");
        out.writeXMLDecl();
        HashMap<String, String> attribs = new HashMap<String, String>();
        attribs.put("clover", "2.2.0");
        attribs.put("generated", String.valueOf(System.currentTimeMillis()));
        out.writeElementStart("coverage", attribs);
        this.writeProject(out, "project", this.mDb.getAppOnlyModel());
        this.writeProject(out, "testproject", this.mDb.getTestOnlyModel());
        out.writeElementEnd("coverage");
        out.close();
    }

    private XMLWriter initWriter() throws IOException {
        BufferedOutputStream os = this.mCfg.isCompress() ? new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(this.mCfg.getOutFile()))) : new BufferedOutputStream(new FileOutputStream(this.mCfg.getOutFile()));
        return new XMLWriter(os, "UTF-8");
    }

    private void writeProject(XMLWriter out, String enclosingTag, ProjectInfo proj) throws IOException {
        HashMap<String, String> attribs = new HashMap<String, String>();
        if (this.mCfg.getTitle() != null) {
            attribs.put("name", this.mCfg.getTitle());
        }
        long ts = this.mDb.getRecordingTimestamp();
        if (this.mCfg.getEffectiveDate() != null) {
            ts = this.mCfg.getEffectiveDate().getTime();
        }
        attribs.put("timestamp", String.valueOf(ts));
        out.writeElementStart(enclosingTag, attribs);
        this.writeMetrics(out, proj.getMetrics());
        List packages = proj.getPackages();
        if (packages != null && packages.size() > 0) {
            boolean summaryReport = false;
            if (this.mCfg instanceof Current) {
                summaryReport = ((Current)this.mCfg).getSummary();
            }
            Iterator it = packages.iterator();
            while (it.hasNext()) {
                PackageInfo pkg = (PackageInfo)it.next();
                attribs = new HashMap();
                attribs.put("name", pkg.getName());
                out.writeElementStart("package", attribs);
                this.writeMetrics(out, pkg.getMetrics());
                if (!summaryReport) {
                    this.writeFilesForPkg(out, pkg);
                }
                out.writeElementEnd("package");
            }
        }
        out.writeElementEnd(enclosingTag);
    }

    private void writeMetrics(XMLWriter out, BlockMetrics metrics) throws IOException {
        HashMap<String, String> attribs = new HashMap<String, String>();
        attribs.put("elements", String.valueOf(metrics.getNumElements()));
        attribs.put("statements", String.valueOf(metrics.getNumStatements()));
        attribs.put("conditionals", String.valueOf(metrics.getNumBranches()));
        attribs.put("coveredelements", String.valueOf(metrics.getNumCoveredElements()));
        attribs.put("coveredstatements", String.valueOf(metrics.getNumCoveredStatements()));
        attribs.put("coveredconditionals", String.valueOf(metrics.getNumCoveredBranches()));
        attribs.put("complexity", String.valueOf(metrics.getComplexity()));
        if (metrics instanceof ClassMetrics) {
            ClassMetrics cm = (ClassMetrics)metrics;
            attribs.put("methods", String.valueOf(cm.getNumMethods()));
            attribs.put("coveredmethods", String.valueOf(cm.getNumCoveredMethods()));
            if (metrics instanceof FileMetrics) {
                FileMetrics fm = (FileMetrics)metrics;
                attribs.put("classes", String.valueOf(fm.getNumClasses()));
                attribs.put("loc", String.valueOf(fm.getLineCount()));
                attribs.put("ncloc", String.valueOf(fm.getNcLineCount()));
                if (metrics instanceof PackageMetrics) {
                    PackageMetrics pm = (PackageMetrics)metrics;
                    attribs.put("files", String.valueOf(pm.getNumFiles()));
                    if (metrics instanceof ProjectMetrics) {
                        ProjectMetrics pjm = (ProjectMetrics)metrics;
                        attribs.put("packages", String.valueOf(pjm.getNumPackages()));
                    }
                }
            }
        }
        out.writeElement("metrics", attribs);
    }

    private void writeFilesForPkg(XMLWriter out, PackageInfo pkg) throws IOException {
        List files = pkg.getFiles();
        Iterator it = files.iterator();
        while (it.hasNext()) {
            FileInfo file = (FileInfo)it.next();
            HashMap<String, String> attribs = new HashMap<String, String>();
            attribs.put("name", file.getName());
            out.writeElementStart("file", attribs);
            this.writeClassesForFile(out, file.getClasses());
            this.writeMetrics(out, file.getMetrics());
            if (this.mCfg.getFormat().getSrcLevel()) {
                this.writeLineInfo(out, file);
            }
            out.writeElementEnd("file");
        }
    }

    private void writeClassesForFile(XMLWriter out, List classes) throws IOException {
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            ClassInfo info = (ClassInfo)it.next();
            HashMap<String, String> attribs = new HashMap<String, String>();
            attribs.put("name", info.getName());
            out.writeElementStart("class", attribs);
            this.writeMetrics(out, info.getMetrics());
            out.writeElementEnd("class");
        }
    }

    private void writeLineInfo(XMLWriter out, FileInfo finfo) throws IOException {
        int linecount = finfo.getLineCount();
        LineInfo[] linfo = finfo.getLineInfo();
        for (int i = 1; i <= linecount; ++i) {
            BranchInfo[] branches;
            StatementInfo[] stmts;
            LineInfo info = linfo[i];
            if (linfo[i] == null) continue;
            MethodInfo[] starts = info.getMethodStarts();
            if (starts != null) {
                for (int m = 0; m < starts.length; ++m) {
                    if (starts[m].isFiltered(this.mContextSet)) continue;
                    HashMap<String, String> attribs = new HashMap<String, String>();
                    attribs.put("num", String.valueOf(i));
                    attribs.put("type", "method");
                    attribs.put("count", String.valueOf(starts[m].getHitCount()));
                    attribs.put("complexity", String.valueOf(starts[m].getComplexity()));
                    attribs.put("signature", XMLWriter.escapeAttributeValue(starts[m].getName()));
                    out.writeElement("line", attribs);
                }
            }
            if ((stmts = info.getStatements()) != null) {
                for (int m = 0; m < stmts.length; ++m) {
                    if (stmts[m].isFiltered(this.mContextSet)) continue;
                    HashMap<String, String> attribs = new HashMap<String, String>();
                    attribs.put("num", String.valueOf(i));
                    attribs.put("type", "stmt");
                    attribs.put("count", String.valueOf(stmts[m].getHitCount()));
                    out.writeElement("line", attribs);
                }
            }
            if ((branches = info.getBranches()) == null) continue;
            for (int m = 0; m < branches.length; ++m) {
                if (branches[m].isFiltered(this.mContextSet)) continue;
                HashMap<String, String> attribs = new HashMap<String, String>();
                attribs.put("num", String.valueOf(i));
                attribs.put("type", "cond");
                attribs.put("truecount", String.valueOf(branches[m].getTrueHitCount()));
                attribs.put("falsecount", String.valueOf(branches[m].getFalseHitCount()));
                out.writeElement("line", attribs);
            }
        }
    }

    private static CloverReportConfig processArgs(String[] args) {
        Current cfg = new Current();
        cfg.setFormat(Format.DEFAULT_XML);
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-o") || args[i].equals("--outfile")) {
                    cfg.setOutFile(new File(args[++i]));
                    continue;
                }
                if (args[i].equals("-i") || args[i].equals("--initstring")) {
                    cfg.setInitString(args[++i]);
                    continue;
                }
                if (args[i].equals("-t") || args[i].equals("--title")) {
                    cfg.setTitle(args[++i]);
                    continue;
                }
                if (args[i].equals("-l") || args[i].equals("--lineinfo")) {
                    cfg.getFormat().setSrcLevel(true);
                    continue;
                }
                if (args[i].equals("-s") || args[i].equals("--span")) {
                    ++i;
                    try {
                        cfg.setSpan(new Interval(args[i]));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        XMLReporter.usage("Invalid interval format. Should be integer followed by unit (s, m, h, d, w).");
                        return null;
                    }
                }
                if (args[i].equals("-d") || args[i].equals("--debug")) {
                    Logger.setDebug(true);
                    continue;
                }
                if (!args[i].equals("-v") && !args[i].equals("--verbose")) continue;
                Logger.setVerbose(true);
            }
            if (!cfg.validate()) {
                XMLReporter.usage(cfg.getValidationFailureReason());
                cfg = null;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            XMLReporter.usage("Missing a parameter.");
            cfg = null;
        }
        return cfg;
    }

    private static void usage(String msg) {
        System.err.println();
        if (msg != null) {
            System.err.println("  *** ERROR: " + msg);
        }
        System.err.println();
        System.err.println("  USAGE: " + (class$com$cenqua$clover$reporters$xml$XMLReporter == null ? (class$com$cenqua$clover$reporters$xml$XMLReporter = XMLReporter.class$("com.cenqua.clover.reporters.xml.XMLReporter")) : class$com$cenqua$clover$reporters$xml$XMLReporter).getName() + " [OPTIONS] PARAMS\n\n" + "  PARAMS:\n" + "    -i, --initstring <string>\tclover initstring\n\n" + "    -o, --outfile <dir>\tthe file to write XML output to.\n\n" + "  OPTIONS:\n" + "    -l, --lineinfo  \t\tinclude source-level coverage info\n\n" + "    -t, --title  <string>\treport title.\n\n" + "    -s, --span <interval>\tSpecifies how far back in time to\n" + "\t\t\t\tinclude coverage recordings from since the last Clover build. In Interval\n" + "\t\t\t\tformat. \"60s\" = 60 seconds, \"1h\" = 1 hour, \"1d\" = 1 day etc.\n\n" + "    -d, --debug \t\tswitch logging level to debug\n\n" + "    -v, --verbose \t\tswitch logging level to verbose\n\n");
        System.err.println();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

