/*
 * Decompiled with CFR 0.152.
 */
package cenqua_com_licensing.atlassian.license.decoder;

import cenqua_com_licensing.atlassian.license.License;
import cenqua_com_licensing.atlassian.license.LicenseType;
import cenqua_com_licensing.atlassian.license.ng.AtlassianLicense;
import cenqua_com_licensing.atlassian.license.ng.ConfluenceLicense;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class LicenseAdaptor
implements License {
    private final AtlassianLicense license;
    private final LicenseType licenseType;

    public LicenseAdaptor(AtlassianLicense license, LicenseType licenseType) {
        this.license = license;
        this.licenseType = licenseType;
    }

    public Date getDateCreated() {
        return this.license.getDateCreated();
    }

    public Date getDatePurchased() {
        return this.license.getDatePurchased();
    }

    public Date getExpiryDate() {
        return this.license.getExpiryDate();
    }

    public long getLicenseDuration() {
        return 0L;
    }

    public String getLicenseId() {
        return this.license.getLicenseId();
    }

    public LicenseType getLicenseType() {
        return this.licenseType;
    }

    public String getOrganisation() {
        return this.license.getOrganisation();
    }

    public String getPartnerName() {
        return this.license.getPartnerName();
    }

    public int getPermittedClusteredNodes() {
        if (this.license instanceof ConfluenceLicense) {
            return ((ConfluenceLicense)this.license).getNumberOfNodesInCluster();
        }
        return 0;
    }

    public int getUsers() {
        return this.license.getNumberOfUsers();
    }

    public boolean isExpired() {
        return this.license.isExpired();
    }

    public boolean isLicenseLevel(Collection levels) {
        String description = this.getLicenseType().getDescription().toLowerCase();
        Iterator iterator = levels.iterator();
        while (iterator.hasNext()) {
            String level = (String)iterator.next();
            if (description.indexOf(level.toLowerCase()) == -1) continue;
            return true;
        }
        return false;
    }
}

