/*
 * Decompiled with CFR 0.152.
 */
package cenqua_com_licensing.atlassian.time.base;

import cenqua_com_licensing.atlassian.time.Chronology;
import cenqua_com_licensing.atlassian.time.DateTimeUtils;
import cenqua_com_licensing.atlassian.time.DurationField;
import cenqua_com_licensing.atlassian.time.DurationFieldType;
import cenqua_com_licensing.atlassian.time.MutablePeriod;
import cenqua_com_licensing.atlassian.time.Period;
import cenqua_com_licensing.atlassian.time.PeriodType;
import cenqua_com_licensing.atlassian.time.ReadableInstant;
import cenqua_com_licensing.atlassian.time.ReadablePartial;
import cenqua_com_licensing.atlassian.time.ReadablePeriod;
import cenqua_com_licensing.atlassian.time.chrono.ISOChronology;
import cenqua_com_licensing.atlassian.time.field.FieldUtils;
import java.io.Serializable;

public abstract class BaseSingleFieldPeriod
implements ReadablePeriod,
Comparable,
Serializable {
    private static final long serialVersionUID = 9386874258972L;
    private int iPeriod;

    protected static int between(ReadableInstant readableInstant, ReadableInstant readableInstant2, DurationFieldType durationFieldType) {
        if (readableInstant == null || readableInstant2 == null) {
            throw new IllegalArgumentException("ReadableInstant objects must not be null");
        }
        Chronology chronology = DateTimeUtils.getInstantChronology(readableInstant);
        int n = durationFieldType.getField(chronology).getDifference(readableInstant2.getMillis(), readableInstant.getMillis());
        return n;
    }

    protected static int between(ReadablePartial readablePartial, ReadablePartial readablePartial2, ReadablePeriod readablePeriod) {
        if (readablePartial == null || readablePartial2 == null) {
            throw new IllegalArgumentException("ReadablePartial objects must not be null");
        }
        if (readablePartial.size() != readablePartial2.size()) {
            throw new IllegalArgumentException("ReadablePartial objects must have the same set of fields");
        }
        int n = 0;
        int n2 = readablePartial.size();
        while (n < n2) {
            if (readablePartial.getFieldType(n) != readablePartial2.getFieldType(n)) {
                throw new IllegalArgumentException("ReadablePartial objects must have the same set of fields");
            }
            ++n;
        }
        if (!DateTimeUtils.isContiguous(readablePartial)) {
            throw new IllegalArgumentException("ReadablePartial objects must be contiguous");
        }
        Chronology chronology = DateTimeUtils.getChronology(readablePartial.getChronology()).withUTC();
        int[] nArray = chronology.get(readablePeriod, chronology.set(readablePartial, 0L), chronology.set(readablePartial2, 0L));
        return nArray[0];
    }

    protected static int standardPeriodIn(ReadablePeriod readablePeriod, long l) {
        if (readablePeriod == null) {
            return 0;
        }
        ISOChronology iSOChronology = ISOChronology.getInstanceUTC();
        long l2 = 0L;
        int n = 0;
        while (n < readablePeriod.size()) {
            int n2 = readablePeriod.getValue(n);
            if (n2 != 0) {
                DurationField durationField = readablePeriod.getFieldType(n).getField(iSOChronology);
                if (!durationField.isPrecise()) {
                    throw new IllegalArgumentException("Cannot convert period to duration as " + durationField.getName() + " is not precise in the period " + readablePeriod);
                }
                l2 = FieldUtils.safeAdd(l2, FieldUtils.safeMultiply(durationField.getUnitMillis(), n2));
            }
            ++n;
        }
        return FieldUtils.safeToInt(l2 / l);
    }

    protected BaseSingleFieldPeriod(int n) {
        this.iPeriod = n;
    }

    protected int getValue() {
        return this.iPeriod;
    }

    protected void setValue(int n) {
        this.iPeriod = n;
    }

    public abstract DurationFieldType getFieldType();

    public abstract PeriodType getPeriodType();

    public int size() {
        return 1;
    }

    public DurationFieldType getFieldType(int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.getFieldType();
    }

    public int getValue(int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.getValue();
    }

    public int get(DurationFieldType durationFieldType) {
        if (durationFieldType == this.getFieldType()) {
            return this.getValue();
        }
        return 0;
    }

    public boolean isSupported(DurationFieldType durationFieldType) {
        return durationFieldType == this.getFieldType();
    }

    public Period toPeriod() {
        return Period.ZERO.withFields(this);
    }

    public MutablePeriod toMutablePeriod() {
        MutablePeriod mutablePeriod = new MutablePeriod();
        mutablePeriod.add(this);
        return mutablePeriod;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ReadablePeriod)) {
            return false;
        }
        ReadablePeriod readablePeriod = (ReadablePeriod)object;
        return readablePeriod.getPeriodType() == this.getPeriodType() && readablePeriod.getValue(0) == this.getValue();
    }

    public int hashCode() {
        int n = 17;
        n = 27 * n + this.getValue();
        n = 27 * n + this.getFieldType().hashCode();
        return n;
    }

    public int compareTo(Object object) {
        if (object.getClass() != this.getClass()) {
            throw new ClassCastException(this.getClass() + " cannot be compared to " + object.getClass());
        }
        int n = ((BaseSingleFieldPeriod)object).getValue();
        int n2 = this.getValue();
        if (n2 > n) {
            return 1;
        }
        if (n2 < n) {
            return -1;
        }
        return 0;
    }
}

