/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.plugin.descriptor;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.impl.DynamicPlugin;
import com.cenqua.fisheye.config.SpringContext;
import com.opensymphony.util.TextUtils;
import org.apache.log4j.Category;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.DOMWriter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class SpringComponentModuleDescriptor
extends AbstractModuleDescriptor
implements StateAware,
ApplicationContextAware {
    private static final Category log = Category.getInstance(SpringComponentModuleDescriptor.class);
    String alias;
    private Document document;
    private ApplicationContext appContext;

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.alias = element.attributeValue("alias");
        if (!TextUtils.stringSet((String)this.alias)) {
            this.alias = this.getKey();
        }
        DocumentFactory factory = DocumentFactory.getInstance();
        Element beans = factory.createElement("beans");
        Element bean = factory.createElement("bean");
        beans.add(bean);
        bean.addAttribute("id", this.alias);
        bean.addAttribute("class", this.getModuleClass().getName());
        for (Attribute a2 : element.attributes()) {
            if (a2.getName().equals("key") || a2.getName().equals("name") || a2.getName().equals("class") || a2.getName().equals("alias")) continue;
            bean.addAttribute(a2.getName(), a2.getValue());
        }
        for (int i2 = 0; i2 < element.nodeCount(); ++i2) {
            if (!(element.node(i2) instanceof Element)) continue;
            bean.add(((Element)element.node(i2)).createCopy());
        }
        this.document = factory.createDocument();
        this.document.add(beans);
    }

    public Object getModule() {
        return SpringContext.getComponent(this.alias);
    }

    public void enabled() {
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)this.appContext.getAutowireCapableBeanFactory();
        if (beanFactory != null) {
            boolean definitionExists;
            try {
                definitionExists = beanFactory.getBeanDefinition(this.alias) != null;
            }
            catch (NoSuchBeanDefinitionException e2) {
                definitionExists = false;
            }
            if (definitionExists) {
                throw new IllegalStateException("Can not overwrite an existing bean definition: " + this.alias);
            }
            log.debug((Object)("Creating bean definition for " + this.alias + " with class " + this.getModuleClass().getName()));
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader(beanFactory);
            if (this.plugin.isDynamicallyLoaded()) {
                reader.setBeanClassLoader(((DynamicPlugin)this.plugin).getClassLoader());
            }
            DOMWriter writer = new DOMWriter();
            try {
                reader.registerBeanDefinitions(writer.write(this.document), (Resource)new ClassPathResource("x"));
                SpringContext.getComponent(this.alias);
            }
            catch (DocumentException de) {
                log.error((Object)"failed to convert Document to DOM", (Throwable)de);
            }
        }
    }

    public void disabled() {
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)this.appContext.getAutowireCapableBeanFactory();
        beanFactory.removeBeanDefinition(this.alias);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appContext = applicationContext;
    }
}

