/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.plugin.rpc;

import com.atlassian.crucible.spi.rpc.CrucibleCXFServlet;
import com.atlassian.fisheye.plugin.descriptor.RpcModuleDescriptor;
import java.util.HashMap;
import java.util.Map;
import javax.xml.ws.Endpoint;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.springframework.stereotype.Component;

@Component(value="rpcModuleManager")
public class RpcModuleManager {
    private boolean initted = false;
    private Map<String, RpcModuleDescriptor> enabledModules = new HashMap<String, RpcModuleDescriptor>();

    public void init(CrucibleCXFServlet servlet) {
        Bus bus = servlet.getBus();
        BusFactory.setDefaultBus((Bus)bus);
        for (RpcModuleDescriptor md : this.enabledModules.values()) {
            this.enableEndpoint(md);
        }
        this.initted = true;
    }

    public void addModule(RpcModuleDescriptor descriptor) {
        if (this.initted) {
            this.enableEndpoint(descriptor);
        }
        this.enabledModules.put(descriptor.getKey(), descriptor);
    }

    public void removeModule(RpcModuleDescriptor descriptor) {
        if (this.initted) {
            this.disableEndpoint(descriptor);
        }
        this.enabledModules.remove(descriptor.getKey());
    }

    private void enableEndpoint(RpcModuleDescriptor descriptor) {
        Endpoint e2 = Endpoint.publish((String)descriptor.getPath(), (Object)descriptor.getModule());
        descriptor.setEndpoint(e2);
    }

    private void disableEndpoint(RpcModuleDescriptor descriptor) {
        descriptor.getEndpoint().stop();
    }
}

